/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.jetty;

import de.cardcontact.opencard.factory.GlobalPlatformCardServiceFactory;
import de.cardcontact.opencard.factory.SmartCardHSMCardServiceFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.kess.createescrow.CreateEscrowKeyServiceRequest;
import org.openscdp.kess.creategroup.CreateGroupServiceRequest;
import org.openscdp.kess.issuekdm.IssueKeyDomainMembershipServiceRequest;
import org.openscdp.kess.joingroup.JoinGroupServiceRequest;
import org.openscdp.kess.receivefromescrow.ReceiveKeyFromEscrowServiceRequest;
import org.openscdp.kess.sendtoescrow.SendKeyToEscrowServiceRequest;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.holder.CVCertificateHolder;
import org.openscdp.pkidm.holder.Holder;
import org.openscdp.pkidm.holder.HolderFactory;
import org.openscdp.pkidm.holder.HolderFactoryBase;
import org.openscdp.pkidm.holder.HolderFactoryRegistry;
import org.openscdp.pkidm.holder.escrow.GroupSigner;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactory;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryBase;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryRegistry;
import org.openscdp.pkidm.subject.Person;
import org.openscdp.pkidm.subject.SubjectFactory;
import org.openscdp.pkidm.subject.SubjectFactoryBase;
import org.openscdp.pkidm.subject.SubjectFactoryRegistry;
import org.openscdp.pkidm.subject.System;
import org.openscdp.pkidm.subject.TrustCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KESSServletContextListener
implements ServletContextListener {
    final Logger logger = LoggerFactory.getLogger(KESSServletContextListener.class);
    public static final String ATTRIBUTE_PKIDM = "PKIDM";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        try {
            java.lang.System.setProperty("OpenCard.loaderClassName", "");
            SmartCard.start();
            CardServiceRegistry csr = CardServiceRegistry.getRegistry();
            csr.add((CardServiceFactory)new GlobalPlatformCardServiceFactory());
            SmartCardHSMCardServiceFactory sccsf = new SmartCardHSMCardServiceFactory();
            sccsf.setAcceptAny(true);
            csr.add((CardServiceFactory)sccsf);
        }
        catch (OpenCardPropertyLoadingException e) {
            this.logger.error("Error loading Opencard properties", (Throwable)e);
        }
        catch (CardServiceException e) {
            this.logger.error("Error creating card service", (Throwable)e);
        }
        catch (CardTerminalException e) {
            this.logger.error("Error creating terminal service", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Terminal or service factory not found", (Throwable)e);
        }
        Jdbi jdbi = (Jdbi)ctx.getAttribute("JDBI");
        PKIDMContext.setJDBI((Jdbi)jdbi);
        ServiceRequestFactoryRegistry registry = PKIDMContext.getServiceRequestFactoryRegistry();
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(CreateGroupServiceRequest.class));
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(JoinGroupServiceRequest.class));
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(IssueKeyDomainMembershipServiceRequest.class));
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(CreateEscrowKeyServiceRequest.class));
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(SendKeyToEscrowServiceRequest.class));
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(ReceiveKeyFromEscrowServiceRequest.class));
        SubjectFactoryRegistry subjectFactory = PKIDMContext.getSubjectFactoryRegistry();
        subjectFactory.addSubjectFactory((SubjectFactory)new SubjectFactoryBase(TrustCenter.class));
        subjectFactory.addSubjectFactory((SubjectFactory)new SubjectFactoryBase(Person.class));
        subjectFactory.addSubjectFactory((SubjectFactory)new SubjectFactoryBase(System.class));
        HolderFactoryRegistry holderRegistry = PKIDMContext.getHolderFactoryRegistry();
        holderRegistry.addHolderFactory((HolderFactory)new HolderFactoryBase(GroupSigner.class));
        HolderFactory cvHolderFactory = new HolderFactory(){

            public String getType() {
                return null;
            }

            public Holder getByDTO(HolderDTO dto) {
                return new CVCertificateHolder(dto);
            }
        };
        holderRegistry.addHolderFactory("DICA", cvHolderFactory);
        holderRegistry.addHolderFactory("SRCA", cvHolderFactory);
        ctx.setAttribute(ATTRIBUTE_PKIDM, (Object)PKIDMContext.getInstance());
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        PKIDMContext pkidmctx = (PKIDMContext)ctx.getAttribute(ATTRIBUTE_PKIDM);
        if (pkidmctx != null) {
            ctx.removeAttribute(ATTRIBUTE_PKIDM);
        }
    }
}

