/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.creategroup;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.util.List;
import opencard.core.OpenCardException;
import org.jdbi.v3.core.Handle;
import org.openscdp.kess.creategroup.CreateGroupServiceRequest;
import org.openscdp.pkicard.groupsigner.CreateSignerContent;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.form.Binder;
import org.openscdp.pkidm.form.Form;
import org.openscdp.pkidm.form.HasValue;
import org.openscdp.pkidm.form.InputField;
import org.openscdp.pkidm.form.Section;
import org.openscdp.pkidm.form.SelectField;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkidm.form.StringInputField;
import org.openscdp.pkidm.form.StringSelectField;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupForm
extends Form {
    private final Logger logger = LoggerFactory.getLogger(CreateGroupForm.class);
    private CreateGroupServiceRequest sr;
    private Binder<CreateSignerContent> binder;
    private Binder.Binding<CreateSignerContent, String> tokenBinding;
    private StringSelectField tokenField;

    public CreateGroupForm(CreateGroupServiceRequest sr) {
        this.sr = sr;
        this.buildForm();
    }

    public void buildForm() {
        this.binder = new Binder(CreateSignerContent.class);
        Section section = new Section();
        section.id = "token";
        section.legend = "msg.kess.groupSigner";
        this.tokenField = this.getTokenField();
        section.fields.add(this.tokenField);
        if (this.sr.getTokenPath() != null) {
            if (this.sr.getLifeCycle() <= 3) {
                try {
                    section.fields.add(this.getKeyDomainField());
                }
                catch (OpenCardException e) {
                    this.logger.error("Key domain enumeration failed", (Throwable)e);
                }
            } else {
                section.fields.add(this.getReadOnlyKeyDomainField());
            }
            if (this.sr.getContent().defaultKeyDomain != null) {
                section.fields.add(this.getCHRField());
                section.fields.add(this.getLabelField());
            }
        }
        this.sections.add(section);
        this.binder.from((Object)this.sr.getContent());
    }

    public boolean saveForm() {
        CreateSignerContent content = this.sr.getContent();
        boolean hasChanged = this.binder.hasChanged((Object)content);
        if (hasChanged) {
            this.binder.to((Object)content);
        }
        if (this.tokenBinding.hasChanged((Object)content)) {
            content.defaultKeyDomain = null;
            content.keyDomains = null;
            if (!this.isValidGroupName(content.holderName)) {
                content.holderName = "";
            }
        }
        return hasChanged;
    }

    private StringInputField getCHRField() {
        StringInputField fld = new StringInputField("holderName", "msg.kess.groupName", InputField.TYPE_TEXT, 11, this.sr.isEditable()){

            public boolean isValid(String value) {
                if (!CreateGroupForm.this.isValidGroupName(value)) {
                    this.message = "A group with that name does already exist";
                    return false;
                }
                return true;
            }
        };
        fld.required = true;
        fld.min = 3;
        fld.max = 11;
        fld.placeholder = "UTGRS1";
        this.binder.bind((HasValue)fld, CreateSignerContent::getHolderName, CreateSignerContent::setHolderName);
        return fld;
    }

    private boolean isValidGroupName(String name) {
        boolean bl;
        block8: {
            Handle handle = PKIDMContext.getJDBI().open();
            try {
                HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
                Long parentId = dao.determineId((String)this.tokenField.getValue(), 1);
                Long holderId = dao.getHolderId(1, parentId, name);
                boolean bl2 = bl = holderId == null;
                if (handle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error("DAO error", (Throwable)e);
                    return false;
                }
            }
            handle.close();
        }
        return bl;
    }

    private StringInputField getLabelField() {
        StringInputField fld = new StringInputField("label", "msg.kess.groupLabel", InputField.TYPE_TEXT, 50, this.sr.isEditable());
        fld.required = true;
        fld.placeholder = "Group Signer 1";
        this.binder.bind((HasValue)fld, CreateSignerContent::getLabel, CreateSignerContent::setLabel);
        return fld;
    }

    private SelectField getParameter() {
        SelectField sf = new SelectField();
        sf.id = "groupParam";
        sf.label = "msg.kess.groupParam";
        return sf;
    }

    private StringSelectField getTokenField() {
        boolean isEditable = this.sr.getLifeCycle() <= 3;
        StringSelectField fld = new StringSelectField("tokenPath", "msg.token", isEditable, true);
        fld.postOnChange = true;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            TokenDAO tokenDAO = (TokenDAO)handle.attach(TokenDAO.class);
            List list = tokenDAO.getTokenList(this.sr.getRecipientId());
            for (TokenDTO token : list) {
                fld.add((SelectFieldValue)new SelectValue(token.getId().longValue(), token.getPath()));
            }
        }
        this.tokenBinding = this.binder.bind((HasValue)fld, CreateSignerContent::getTokenPath, CreateSignerContent::setTokenPath);
        return fld;
    }

    private SelectField getKeyDomainField() throws OpenCardException {
        boolean isEditable = this.sr.getLifeCycle() <= 3;
        SelectField fld = new SelectField("keyDomain", "msg.keydomain", isEditable, true);
        fld.postOnChange = true;
        HSMService hsmService = PKIDMContext.getHSMService();
        SmartCardHSMProvider provider = hsmService.getProvider(this.sr.getTokenPath());
        if (provider != null) {
            SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
            this.sr.setKeyDomains(service.getDefaultKeyDomainUID(), service.getKeyDomains());
        }
        if (this.sr.getContent().defaultKeyDomain != null) {
            int hashCode = this.sr.getContent().defaultKeyDomain.hashCode();
            fld.add((SelectFieldValue)new SelectValue((long)hashCode, "Default (" + this.sr.getContent().defaultKeyDomain.substring(0, 6) + "...)"));
            for (String kd : this.sr.getContent().keyDomains) {
                fld.add((SelectFieldValue)new SelectValue((long)kd.hashCode(), kd));
            }
            fld.required = true;
        } else {
            fld.editable = false;
        }
        this.binder.bind((HasValue)fld, CreateSignerContent::getKeyDomain, CreateSignerContent::setKeyDomain);
        return fld;
    }

    private StringInputField getReadOnlyKeyDomainField() {
        StringInputField fld = new StringInputField("keyDomain", "msg.kess.keyDomain", InputField.TYPE_TEXT, 50, false);
        fld.value = this.sr.getKeyDomain().equals(this.sr.getContent().defaultKeyDomain) ? "Default (" + this.sr.getContent().defaultKeyDomain.substring(0, 6) + "...)" : this.sr.getKeyDomain();
        return fld;
    }
}

