/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.createescrow;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openscdp.kess.createescrow.CreateEscrowKeyServiceRequest;
import org.openscdp.pkicard.escrow.create.CreateEscrowKeyContent;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.form.Binder;
import org.openscdp.pkidm.form.Form;
import org.openscdp.pkidm.form.HasValue;
import org.openscdp.pkidm.form.InputField;
import org.openscdp.pkidm.form.Section;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkidm.form.StringInputField;
import org.openscdp.pkidm.form.StringSelectField;
import org.openscdp.pkidm.holder.escrow.GroupSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEscrowKeyForm
extends Form {
    private final Logger logger = LoggerFactory.getLogger(CreateEscrowKeyForm.class);
    private CreateEscrowKeyServiceRequest sr;
    private Binder<CreateEscrowKeyContent> binder;
    private Binder.Binding<CreateEscrowKeyContent, String> tokenBinding;
    private StringInputField holderNameField;
    private StringSelectField tokenField;

    public CreateEscrowKeyForm(CreateEscrowKeyServiceRequest sr) {
        this.sr = sr;
        this.buildForm();
    }

    public void buildForm() {
        this.binder = new Binder(CreateEscrowKeyContent.class);
        Section section = new Section();
        section.id = "token";
        section.legend = "msg.kess.createEscrow";
        section.fields.add(this.getGroupNameField());
        this.tokenField = this.getEscrowToken();
        section.fields.add(this.tokenField);
        if (this.sr.getContent().getTokenPath() != null) {
            this.holderNameField = this.getHolderNameField();
            section.fields.add(this.holderNameField);
        }
        this.sections.add(section);
        this.binder.from((Object)this.sr.getContent());
    }

    public boolean saveForm() {
        boolean hasChanged;
        CreateEscrowKeyContent content = this.sr.getContent();
        if (this.tokenBinding.hasChanged((Object)content) && this.holderNameField != null && !this.isValidName((String)this.tokenField.getValue(), (String)this.holderNameField.getValue())) {
            this.holderNameField.setValue(null);
        }
        if (hasChanged = this.binder.hasChanged((Object)content)) {
            this.binder.to((Object)content);
        }
        return hasChanged;
    }

    private boolean isEditable() {
        return this.sr.getLifeCycle() <= 2;
    }

    private StringSelectField getEscrowToken() {
        boolean isEditable = this.sr.getLifeCycle() <= 3;
        StringSelectField fld = new StringSelectField("tokenPath", "msg.token", isEditable, true);
        fld.postOnChange = true;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            Long groupSignerHolderId = this.sr.getContent().groupSignerHolderId;
            List list = holderDAO.getHolderListBySubjectTypeAndParent(this.sr.getRecipientId(), "GroupMember", groupSignerHolderId);
            for (HolderDTO groupMember : list) {
                fld.add((SelectFieldValue)new SelectValue(groupMember.getId().longValue(), groupMember.getName()));
            }
        }
        this.tokenBinding = this.binder.bind((HasValue)fld, CreateEscrowKeyContent::getTokenPath, CreateEscrowKeyContent::setTokenPath);
        return fld;
    }

    private StringInputField getHolderNameField() {
        StringInputField fld = new StringInputField("holderName", "msg.kess.escrowName", InputField.TYPE_TEXT, 11, this.isEditable()){

            public boolean isValid(String value) {
                if (value == null || value.length() == 0) {
                    this.message = "Name is required";
                    return false;
                }
                if (!CreateEscrowKeyForm.this.isValidName(value)) {
                    this.message = "Am escrow with that name does already exist";
                    return false;
                }
                return true;
            }
        };
        fld.required = true;
        fld.min = 3;
        fld.max = 11;
        fld.placeholder = "UTEKT1";
        this.binder.bind((HasValue)fld, CreateEscrowKeyContent::getHolderName, CreateEscrowKeyContent::setHolderName);
        return fld;
    }

    private boolean isValidName(String name) {
        String tokenPath = this.sr.getContent().getTokenPath();
        if (tokenPath == null) {
            return false;
        }
        return this.isValidName(tokenPath, name);
    }

    private boolean isValidName(String tokenPath, String name) {
        boolean bl;
        block10: {
            if (tokenPath == null || tokenPath.length() == 0) {
                return false;
            }
            if (name == null || name.length() == 0) {
                return false;
            }
            Handle handle = PKIDMContext.getJDBI().open();
            try {
                HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
                Long issuerId = dao.determineId(tokenPath, 1);
                Long id = dao.getHolderId(1, issuerId, name);
                boolean bl2 = bl = id == null;
                if (handle == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error("DAO error", (Throwable)e);
                    return false;
                }
            }
            handle.close();
        }
        return bl;
    }

    private StringInputField getGroupNameField() {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            Long groupSignerHolderId = this.sr.getContent().groupSignerHolderId;
            HolderDTO holder = dao.getHolder(groupSignerHolderId);
            GroupSigner gs = new GroupSigner(holder);
            String value = gs.getContent().label + " (" + gs.getName() + ")";
            StringInputField stringInputField = new StringInputField("group", "msg.kess.group", InputField.TYPE_TEXT, 50, false, value);
            return stringInputField;
        }
    }
}

