/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2025 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Group Member Holder View
 */

var HolderView		= require('pki-as-a-service/ui/HolderView').HolderView;

function GroupMemberHolderView(service, holder) {
    this.service = service;
    this.holder = holder;
	GPSystem.log(GPSystem.DEBUG, module.id, "new GroupMemberHolderView()");
}

GroupMemberHolderView.prototype = Object.create(HolderView.prototype);
GroupMemberHolderView.constructor = GroupMemberHolderView;

exports.GroupMemberHolderView = GroupMemberHolderView;



GroupMemberHolderView.prototype.getSummary = function(homeURL, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var holderDAO = this.service.daof.getHolderDAO();
    var content = this.holder.getContent();
	var gsHolder = holderDAO.getHolderById(this.holder.parentId);

    var name = this.holder.name.substr(this.holder.name.lastIndexOf("/") + 1);

	var summary = <summary class="paas-holder-view-summary">
		<h3 class="paas-holder-view-heading" id={this.holder.id}>{ this.holder.type } { name } in { gsHolder.name }</h3>
		<div id="holdermenu" class= "paas-holder-view-li paas-holder-view-holder-menu">
		</div>
	</summary>

	return summary;
}
