/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2023 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for creating a new Group Signer
 */

var BackendServiceRequestControllerBase = require('pki-as-a-service/ui/BackendServiceRequestControllerBase').BackendServiceRequestControllerBase;
var KESSRequestController = require('kess/processes/KESSRequestController').KESSRequestController;
var I18N = require('scsh/srv-cc1/I18N').I18N;



I18N.addResources([
 	{ lang: "EN", keys: {
		"msg.kess.createEscrow": "Create Escrow Key Data",
		"action.kess.createEscrow": "Create Escrow Key",
 	}}
 ]);



function CreateEscrowKeyRequestController(plugin) {
	GPSystem.log(GPSystem.DEBUG, module.id, "new CreateEscrowKeyRequestController()");
	KESSRequestController.call(this, plugin);
}

exports.CreateEscrowKeyRequestController = CreateEscrowKeyRequestController;

CreateEscrowKeyRequestController.prototype = Object.create(KESSRequestController.prototype);



CreateEscrowKeyRequestController.prototype.postCreateAction = function(req, res, srct, action, subject, holder) {
	var data = { process: "CreateEscrowKey",
		originatorId: srct.ui.session.user.id,
		recipientId: subject.getId(),
		content: {
			groupSignerHolderId: holder.parentId
		}
	};

	return BackendServiceRequestControllerBase.prototype.postCreateActionViaAPI.call(this, req, res, srct, data);
}



CreateEscrowKeyRequestController.prototype.getCreateView = function(req, res, srct, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var view =	<div>
				<h1>Create Escrow Target Key</h1>

				<p>The Escrow Key is the target for which cryptographic keys are encrypted when send to escrow.</p>

				<p>The Escrow Key must be part of the key domain for which keys can migrate. It may be offline, as
				   only the public key is relevant for sending keys into escrow.</p>

				<p>The private key on a SmartCard-HSM is only required to unwrap and import the key from
				   the database and eventually forward the key to the final destination to recover the key from escrow.</p>

				<form class="pure-form" action="" method="post" enctype="multipart/form-data">
					<button class="pure-button" type="submit" name="action" value="create">Start Request</button>
				</form>
			</div>

	return view;
}
