/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2023 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Common service request controller for Key Escrow Service
 */

var BackendServiceRequestControllerBase = require('pki-as-a-service/ui/BackendServiceRequestControllerBase').BackendServiceRequestControllerBase;

var I18N = require('scsh/srv-cc1/I18N').I18N;



I18N.addResources([
 	{ lang: "EN", keys: {
		"msg.kess.groupSigner": "Group Signer",
        "msg.kess.group": "Group",
        "msg.kess.groupName": "Group Name",
        "msg.kess.groupName.tooltip": "An up to 11-character unique group name encoded as CHR in the group signer CV-Certificate",
        "msg.kess.groupLabel": "Group Label",
        "msg.kess.groupLabel.tooltip": "A human readable descriptive label for the group",
        "msg.kess.escrowName": "Escrow Name",
        "msg.kess.escrowName.tooltip": "An up to 11-character unique escrow name encoded as CHR in the escrow key CV-Certificate",
		"msg.kess.holderName": "Name",
		"msg.kess.keyDomain": "Key Domain",

		"action.signer.create": "Create Signer",
 	}}
 ]);



function KESSRequestController(plugin) {
	GPSystem.log(GPSystem.DEBUG, module.id, "new KESSRequestController()");
	BackendServiceRequestControllerBase.call(this, plugin);
}

exports.KESSRequestController = KESSRequestController;

KESSRequestController.prototype = Object.create(BackendServiceRequestControllerBase.prototype);
KESSRequestController.constructor = KESSRequestController;
