/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.est.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cmc.CMCException;
import org.bouncycastle.cmc.SimplePKIResponse;

public class SimplePKIResponseGenerator {
    List<ASN1Encodable> certs = new ArrayList<ASN1Encodable>();

    public void addCertificate(X509CertificateHolder certificate) {
        this.certs.add((ASN1Encodable)certificate.toASN1Structure());
    }

    public SimplePKIResponse generate() {
        ContentInfo encInfo = new ContentInfo(CMSObjectIdentifiers.data, null);
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator<ASN1Encodable> it = this.certs.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        DERSet certificates = new DERSet(v);
        SignedData sd = new SignedData((ASN1Set)new DERSet(), encInfo, (ASN1Set)certificates, null, (ASN1Set)new DERSet());
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)sd);
        SimplePKIResponse spr = null;
        try {
            spr = new SimplePKIResponse(contentInfo);
        }
        catch (CMCException e) {
            throw new RuntimeException("Creating SimplePKIResponse failed", e);
        }
        return spr;
    }
}

