/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.SecureService;
import opencard.opt.security.SecurityDomain;
import opencard.opt.util.PassThruCardService;

public class TransparentCardService
extends PassThruCardService
implements SecureService {
    private CredentialBag credentialBag = null;
    private SecurityDomain securityDomain;

    @Override
    public void provideCredentials(SecurityDomain domain, CredentialBag creds) throws CardServiceException {
        this.securityDomain = domain == null ? new CardFilePath(":3F00") : domain;
        this.credentialBag = creds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU sendCommandAPDU(CommandAPDU command, int usageQualifier) throws CardTerminalException {
        ResponseAPDU response;
        IsoCredentialStore ics;
        SecureChannelCredential secureChannelCredential = null;
        if (this.credentialBag != null && (ics = (IsoCredentialStore)this.credentialBag.getCredentialStore(null, IsoCredentialStore.class)) != null) {
            secureChannelCredential = ics.getSecureChannelCredential(this.securityDomain);
        }
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            if (secureChannelCredential != null) {
                SlotChannel slc = channel.getSlotChannel();
                APDUTracer tracer = slc.getAPDUTracer();
                if (tracer != null && command.getLength() > 5) {
                    tracer.traceCommandAPDU(slc, command);
                }
                SecureChannel secureChannel = secureChannelCredential.getSecureChannel();
                command = secureChannel.wrap(command, usageQualifier);
                response = channel.sendCommandAPDU(command);
                response = secureChannel.unwrap(response, usageQualifier);
                if (tracer != null && response.getLength() > 2) {
                    tracer.traceResponseAPDU(slc, response);
                }
            } else {
                response = channel.sendCommandAPDU(command);
            }
        }
        finally {
            this.releaseCardChannel();
        }
        return response;
    }
}

