/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.form;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.openscdp.pkidm.form.Field;
import org.openscdp.pkidm.form.FileUpload;
import org.openscdp.pkidm.form.MultiSelectField;
import org.openscdp.pkidm.form.NumberInputField;
import org.openscdp.pkidm.form.Section;
import org.openscdp.pkidm.form.SelectField;
import org.openscdp.pkidm.form.StringInputField;
import org.openscdp.pkidm.form.StringMultiSelectField;
import org.openscdp.pkidm.form.StringSelectField;
import org.openscdp.pkidm.form.ValueField;
import org.openscdp.pkidm.json.JSONByteString;

public class Form {
    public String id;
    public String legend;
    public List<Section> sections = new LinkedList<Section>();

    public List<Section> getSections() {
        return this.sections;
    }

    private boolean setField(ValueField field, JsonNode n) {
        if (field instanceof StringInputField) {
            StringInputField f = (StringInputField)field;
            String val = n.asText();
            f.setValue(val);
            if (!f.isValid(val)) {
                return false;
            }
        } else if (field instanceof NumberInputField) {
            NumberInputField f = (NumberInputField)field;
            String val = n.asText();
            if (!val.isEmpty()) {
                int value;
                try {
                    value = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                f.setValue(value);
                if (!f.isValid(value)) {
                    return false;
                }
            } else if (f.required) {
                return false;
            }
        } else if (field instanceof SelectField) {
            SelectField f = (SelectField)field;
            Long val = n.asLong();
            if (!f.isValid(val)) {
                return false;
            }
            f.setValue(val);
        } else if (field instanceof StringSelectField) {
            StringSelectField f = (StringSelectField)field;
            if (!f.setValueFromId(n.asLong())) {
                return false;
            }
        } else if (field instanceof StringMultiSelectField) {
            StringMultiSelectField f = (StringMultiSelectField)field;
            TextNode tn = (TextNode)n;
            String[] values = tn.asText().split(",");
            List<Long> valueList = Arrays.stream(values).map(Long::valueOf).collect(Collectors.toList());
            f.setValueFromIds(valueList);
        } else if (field instanceof MultiSelectField) {
            MultiSelectField f = (MultiSelectField)field;
            TextNode tn = (TextNode)n;
            String[] values = tn.asText().split(",");
            List<Long> valueList = Arrays.stream(values).map(Long::valueOf).collect(Collectors.toList());
            if (!f.isValid(valueList)) {
                return false;
            }
            f.setValue(valueList);
        } else if (field instanceof FileUpload) {
            JSONByteString bs;
            FileUpload f = (FileUpload)field;
            ObjectMapper om = new ObjectMapper();
            try {
                bs = (JSONByteString)om.treeToValue((TreeNode)n, JSONByteString.class);
            }
            catch (Exception e) {
                return false;
            }
            if (bs.asByteArray().length > 0) {
                f.setValue(bs);
            }
        }
        return true;
    }

    public boolean setFields(JsonNode input) {
        boolean isValid = true;
        for (Section section : this.sections) {
            for (Field field : section.fields) {
                String id;
                JsonNode n;
                if (!(field instanceof ValueField)) continue;
                ValueField valueField = (ValueField)field;
                if (!valueField.editable || (n = input.get(id = field.id)) == null || this.setField(valueField, n)) continue;
                isValid = false;
            }
        }
        return isValid;
    }
}

