/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.est.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelAndOperation {
    final Logger logger = LoggerFactory.getLogger(LabelAndOperation.class);
    String[] pathInfo;
    int operation = -1;
    static final String[] operations = new String[]{"cacerts", "simpleenroll", "simplereenroll"};
    static final int CACERTS = 0;
    static final int SIMPLEENROLL = 1;
    static final int SIMPLEREENROLL = 2;
    final Pattern allowedInLabel = Pattern.compile("[A-Za-z0-9_\\- ]+");

    LabelAndOperation(String pathInfo) {
        this.pathInfo = pathInfo.split("/");
    }

    boolean isValid() {
        Matcher matcher;
        if (this.pathInfo.length < 2 || this.pathInfo.length > 3) {
            this.logger.error("URL does not contain '/operation' or '/label/operation'");
            return false;
        }
        if (this.pathInfo[0].length() != 0) {
            this.logger.error("URL does not start with /");
            return false;
        }
        if (this.pathInfo.length == 3 && !(matcher = this.allowedInLabel.matcher(this.pathInfo[1])).matches()) {
            this.logger.error("Label contains illegal characters");
            return false;
        }
        String op = this.pathInfo[this.pathInfo.length - 1];
        for (int i = 0; i < operations.length; ++i) {
            if (!operations[i].equals(op)) continue;
            this.operation = i;
            break;
        }
        return this.operation != -1;
    }

    int getOperation() {
        return this.operation;
    }

    boolean hasLabel() {
        return this.pathInfo.length > 2;
    }

    String getLabel() {
        if (!this.hasLabel()) {
            return "";
        }
        return this.pathInfo[1];
    }
}

