/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.est.server;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.est.server.ESTEnrollRequest;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.est.ESTServiceRequestContent;

public class ESTReenrollRequest
extends ESTEnrollRequest {
    ESTReenrollRequest(HttpServletRequest req, HttpServletResponse resp, String label) {
        super(req, resp, label);
    }

    @Override
    void checkDuplicateMessageId() {
        ServiceRequestDTO dto;
        ServiceRequestDAO dao;
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dto = dao.getServiceRequest(this.activeCertSRId);
        }
        if (dto == null) {
            return;
        }
        if (!this.messageId.equals(dto.getMessageId())) {
            return;
        }
        handle = jdbi.open();
        try {
            dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dao.updateMessageId(null, dto.getId());
        }
        finally {
            if (handle != null) {
                handle.close();
            }
        }
    }

    @Override
    boolean isAuthorized() throws IOException {
        if (!this.hasTLSClientCertificateInRequest()) {
            return false;
        }
        if (!this.isActiveCertificate()) {
            this.reportError(401, "TLS client certificate is not the current certificate");
            return false;
        }
        if (!this.isGoodCertificate()) {
            return false;
        }
        if (!this.trustCenterConfig.getIssuerIds().contains(this.tlsClientCertIssuer)) {
            this.reportError(401, "TLS client certificate was not issued by this signer");
            return false;
        }
        return true;
    }

    @Override
    void configureServiceRequestGenerator(ServiceRequestDTO dto) {
        dto.setTitle("EST Reenrollment");
        dto.setParentServiceRequestId(this.activeCertSRId);
        dto.setAssignedToRole(this.trustCenter.getCaRoleId());
    }

    @Override
    void determineCommonName(ESTServiceRequestContent content) {
        X500Name x500name = this.tlsclientcert.getSubject();
        RDN[] cns = x500name.getRDNs(BCStyle.CN);
        content.commonName = cns.length >= 1 ? IETFUtils.valueToString((ASN1Encodable)cns[0].getFirst().getValue()) : "CommonName";
    }

    @Override
    void determineLifeCycle() {
        this.sr.setLifeCycle(6);
    }
}

