/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.est.server;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.encoders.Hex;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.est.server.ESTRequestBase;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.est.ESTServiceRequest;
import org.openscdp.pkidm.est.ESTServiceRequestContent;
import org.openscdp.pkidm.est.ESTServiceRequestGenerator;
import org.openscdp.pkidm.json.JSONByteString;
import org.openscdp.pkidm.servicerequest.ServiceRequestContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESTEnrollRequest
extends ESTRequestBase {
    final Logger logger = LoggerFactory.getLogger(ESTEnrollRequest.class);
    Long originatorId;
    X509CertificateHolder tlsclientcert;
    int tlsclientcertstatus = 1;
    Long tlsClientCertIssuer;
    PKCS10CertificationRequest pkcs10;
    String messageId;
    Long holderId;
    Long activeCertSRId;
    ESTServiceRequest sr;

    ESTEnrollRequest(HttpServletRequest req, HttpServletResponse resp, String label) {
        super(req, resp, label);
    }

    boolean isContentTypeValid() throws IOException {
        if (!this.req.getContentType().equals("application/pkcs10")) {
            this.reportError(415, "Unsupported media type " + this.req.getContentType());
            return false;
        }
        return true;
    }

    boolean hasTLSClientCertificateInRequest() throws IOException {
        String str = this.req.getHeader("X-TLS-Client-Certificate");
        if (str == null) {
            this.reportError(400, "Client certificate in header X-TLS-Client-Certificate missing");
            return false;
        }
        if (!str.startsWith("-----BEGIN CERTIFICATE----- ") || !str.endsWith(" -----END CERTIFICATE-----")) {
            this.reportError(400, "Certificate begin / end marker missing");
            return false;
        }
        str = str.substring(28, str.length() - 26);
        str = str.replace(" ", "");
        byte[] certbin = Base64.getDecoder().decode(str);
        this.tlsclientcert = new X509CertificateHolder(certbin);
        return true;
    }

    boolean isActiveCertificate() throws IOException {
        BcX509ExtensionUtils exutil = new BcX509ExtensionUtils();
        SubjectKeyIdentifier ski = exutil.createSubjectKeyIdentifier(this.tlsclientcert.getSubjectPublicKeyInfo());
        Object serial = this.tlsclientcert.getSerialNumber().toString(16).toUpperCase();
        if ((((String)serial).length() & 1) == 1) {
            serial = "0" + (String)serial;
        }
        Jdbi jdbi = PKIDMContext.getJDBI();
        CertificateDTO certdto = null;
        try (Handle handle = jdbi.open();){
            CertificateDAO dao = (CertificateDAO)handle.attach(CertificateDAO.class);
            certdto = dao.getCertificateByKeyIdAndSerial(ski.getKeyIdentifier(), (String)serial);
        }
        if (certdto == null) {
            this.logger.debug("No active certificate found for subject key identifier and serial");
            return false;
        }
        this.tlsclientcertstatus = certdto.getStatus();
        this.holderId = (long)certdto.getHolderId();
        this.activeCertSRId = certdto.getServiceRequestId();
        return true;
    }

    boolean isFromTrustedCertificateIssuer() throws IOException {
        AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.fromExtensions((Extensions)this.tlsclientcert.getExtensions());
        Jdbi jdbi = PKIDMContext.getJDBI();
        List certdtos = null;
        try (Handle handle = jdbi.open();){
            CertificateDAO dao = (CertificateDAO)handle.attach(CertificateDAO.class);
            certdtos = dao.getCertificateByKeyId(aki.getKeyIdentifier());
        }
        if (certdtos.isEmpty()) {
            this.reportError(401, "No certificate issuer found for authority key identifier");
            return false;
        }
        Long certId = ((CertificateDTO)certdtos.get(0)).getId();
        if (!this.trustCenterConfig.isTrustedESTCACert(certId)) {
            this.reportError(401, "Issuing CA is not trusted");
            return false;
        }
        return true;
    }

    boolean isGoodCertificate() throws IOException {
        HolderDTO holderdto;
        if (this.tlsclientcertstatus != 0) {
            this.reportError(401, "TLS client certificate is revoked");
            return false;
        }
        if (!this.tlsclientcert.isValidOn(new Date())) {
            this.reportError(401, "TLS client not yet valid or expired");
            return false;
        }
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            holderdto = dao.getHolder(this.holderId);
        }
        this.originatorId = holderdto.getSubjectId();
        this.tlsClientCertIssuer = holderdto.getParentId();
        return true;
    }

    boolean isAuthorized() throws IOException {
        if (!this.hasTLSClientCertificateInRequest()) {
            return false;
        }
        if (this.isActiveCertificate()) {
            if (!this.isGoodCertificate()) {
                return false;
            }
        } else {
            if (!this.isFromTrustedCertificateIssuer()) {
                return false;
            }
            this.originatorId = this.getESTServer().getId();
        }
        return true;
    }

    private boolean isPKCS10RequestValid() throws IOException {
        ServletInputStream is = this.req.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is));
        Stream<String> l = r.lines();
        String base64 = l.filter(s -> !s.startsWith("--")).collect(Collectors.joining());
        byte[] bin = Base64.getDecoder().decode(base64);
        this.pkcs10 = new PKCS10CertificationRequest(bin);
        try {
            ContentVerifierProvider prov = new JcaContentVerifierProviderBuilder().build(this.pkcs10.getSubjectPublicKeyInfo());
            if (!this.pkcs10.isSignatureValid(prov)) {
                String msg = "PKCS10 signature verification failed";
                this.logger.error(msg);
                this.resp.sendError(400, msg);
                return false;
            }
        }
        catch (OperatorCreationException | PKCSException oce) {
            String msg = "Could not verify PKCS#10 request";
            this.logger.error(msg, oce);
            this.resp.sendError(400, msg);
            return false;
        }
        BcX509ExtensionUtils exutil = new BcX509ExtensionUtils();
        SubjectKeyIdentifier ski = exutil.createSubjectKeyIdentifier(this.pkcs10.getSubjectPublicKeyInfo());
        this.messageId = Hex.toHexString((byte[])ski.getKeyIdentifier());
        return true;
    }

    void checkDuplicateMessageId() {
    }

    private boolean hasExistingServiceRequest() {
        ServiceRequestDTO dto;
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dto = dao.getServiceRequestByMessageId(this.messageId);
        }
        if (dto == null) {
            return false;
        }
        this.sr = (ESTServiceRequest)PKIDMContext.getServiceRequestFactoryRegistry().getByDTO(dto);
        return true;
    }

    void configureServiceRequestGenerator(ServiceRequestDTO dto) {
        dto.setTitle("EST Enrollment");
    }

    void determineCommonName(ESTServiceRequestContent content) {
        X500Name x500name = this.pkcs10.getSubject();
        RDN[] cns = x500name.getRDNs(BCStyle.CN);
        content.commonName = cns.length >= 1 ? IETFUtils.valueToString((ASN1Encodable)cns[0].getFirst().getValue()) : "CommonName";
    }

    void determineLifeCycle() {
        this.sr.setLifeCycle(3);
    }

    boolean createNewServiceRequest() throws IOException {
        ESTServiceRequestGenerator gen = new ESTServiceRequestGenerator(this.originatorId);
        gen.dto().setRecipientId(this.trustCenter.getId());
        gen.dto().setMessageId(this.messageId);
        this.configureServiceRequestGenerator(gen.dto());
        gen.dto().setDetails(this.pkcs10.getSubject().toString());
        ESTServiceRequestContent content = new ESTServiceRequestContent();
        List issuerIds = this.trustCenterConfig.getIssuerIds();
        if (issuerIds.size() == 1) {
            content.issuer = (Long)issuerIds.get(0);
        }
        content.autoEnroll = this.trustCenterConfig.doAutoEnroll();
        this.determineCommonName(content);
        content.creq = new JSONByteString(this.pkcs10.getEncoded());
        gen.setContent((ServiceRequestContent)content);
        this.sr = gen.generate();
        this.sr.setStatusInfo("Request received");
        this.determineLifeCycle();
        this.sr.commit(this.originatorId, null);
        int rc = this.pingService(this.sr.getId());
        if (rc == 200) {
            this.sr = (ESTServiceRequest)PKIDMContext.getServiceRequestFactoryRegistry().getById(this.sr.getId(), ESTServiceRequest.class);
            return true;
        }
        this.resp.setHeader("Retry-After", String.valueOf(this.trustCenterConfig.getRetryAfter()));
        this.resp.setStatus(202);
        return false;
    }

    private boolean hasIssuedCertificates() throws IOException {
        int lc = this.sr.getLifeCycle();
        if (lc != 7 && lc != 11) {
            this.resp.setHeader("Retry-After", String.valueOf(this.trustCenterConfig.getRetryAfter()));
            this.resp.setStatus(202);
            return false;
        }
        ESTServiceRequestContent content = this.sr.getContent();
        if (content.certIdList == null || content.certIdList.length == 0) {
            this.resp.setHeader("Retry-After", String.valueOf(this.trustCenterConfig.getRetryAfter()));
            this.resp.setStatus(202);
            return false;
        }
        this.pingService(this.sr.getId());
        this.certs = new ArrayList();
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            CertificateDAO dao = (CertificateDAO)handle.attach(CertificateDAO.class);
            for (int i : content.certIdList) {
                CertificateDTO certdto = dao.getCertificate(Long.valueOf(i));
                X509CertificateHolder cert = new X509CertificateHolder(certdto.getBytes());
                this.certs.add(cert);
            }
        }
        return true;
    }

    @Override
    public void handleRequest() throws IOException {
        if (!this.isContentTypeValid()) {
            return;
        }
        if (!this.isValidLabel()) {
            return;
        }
        if (!this.hasTrustCenterJoined()) {
            return;
        }
        if (!this.isAuthorized()) {
            return;
        }
        if (!this.isPKCS10RequestValid()) {
            return;
        }
        this.checkDuplicateMessageId();
        if (this.hasExistingServiceRequest()) {
            if (this.hasIssuedCertificates()) {
                this.returnCertificates();
            }
        } else if (this.createNewServiceRequest() && this.hasIssuedCertificates()) {
            this.returnCertificates();
        }
    }
}

