/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.persistence;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.persistence.Certificates;
import org.openscdp.pkidm.persistence.DAOFactory;
import org.openscdp.pkidm.persistence.DBCertificates;
import org.openscdp.pkidm.persistence.DBHolders;
import org.openscdp.pkidm.persistence.DBRequests;
import org.openscdp.pkidm.persistence.DBSigners;
import org.openscdp.pkidm.persistence.Holders;
import org.openscdp.pkidm.persistence.Requests;
import org.openscdp.pkidm.persistence.Signers;

public class DAOFactoryDatabase
implements DAOFactory {
    private static DBHolders holders;
    private static DBCertificates certs;
    private DBSigners signers;
    private DBRequests requests;
    private Handle handle;
    private int openConnections = 0;

    @Override
    public DAOFactory open() {
        if (this.openConnections++ == 0) {
            Jdbi jdbi = PKIDMContext.getJDBI();
            this.handle = jdbi.open();
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        if (this.openConnections-- == 0) {
            return;
        }
        if (this.openConnections == 0) {
            this.handle.close();
            holders = null;
            certs = null;
            this.signers = null;
            this.requests = null;
        }
    }

    @Override
    public Holders getHolders() {
        if (holders == null) {
            holders = new DBHolders(this.handle);
        }
        return holders;
    }

    @Override
    public Certificates getCertificates() {
        if (certs == null) {
            certs = new DBCertificates(this.handle);
        }
        return certs;
    }

    @Override
    public Signers getSigners() {
        if (this.signers == null) {
            this.signers = new DBSigners(this.handle);
        }
        return this.signers;
    }

    @Override
    public Requests getRequests() {
        if (this.requests == null) {
            this.requests = new DBRequests(this.handle);
        }
        return this.requests;
    }
}

