/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.holder;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.cvc.CVCSigner;
import org.openscdp.pkidm.holder.CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVCertificateHolder
extends CertificateHolder {
    final Logger logger = LoggerFactory.getLogger(CVCertificateHolder.class);

    public CVCertificateHolder(HolderDTO dto) {
        super(dto);
    }

    public CVCertificateHolder getParent() {
        return super.getParent(CVCertificateHolder.class);
    }

    public CardVerifiableCertificate getCurrentCertificate() {
        CertificateDTO certDTO = this.getCurrentCertificateDTO();
        if (certDTO == null) {
            return null;
        }
        try {
            return new CardVerifiableCertificate(certDTO.getBytes());
        }
        catch (CertificateException e) {
            throw new RuntimeException("Invalid certificate in database", e);
        }
    }

    public CardVerifiableCertificate getIssuingCertificate(CertificationAuthorityReference car) {
        List certs;
        CVCertificateHolder parent = this.getParent();
        if (parent == null) {
            parent = this;
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            CertificateDAO dao = (CertificateDAO)handle.attach(CertificateDAO.class);
            certs = dao.getCertificateBySerial(parent.getId(), car.toString());
            if (certs.size() > 1) {
                throw new RuntimeException("Certificate chain is not distinct for holder " + parent.getName());
            }
            if (certs.size() != 1) {
                CardVerifiableCertificate cardVerifiableCertificate = null;
                return cardVerifiableCertificate;
            }
        }
        try {
            return new CardVerifiableCertificate(((CertificateDTO)certs.get(0)).getBytes());
        }
        catch (CertificateException e) {
            throw new RuntimeException("Invalid certificate in database", e);
        }
    }

    protected static CertificateDTO toCertificateDTO(CardVerifiableCertificate cvc) {
        CertificateDTO certDTO = new CertificateDTO();
        try {
            certDTO.setBytes(cvc.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        String chr = cvc.getCertificateHolderReference().toString();
        certDTO.setKeyId(cvc.getSubjectPublicKeyIdentifier());
        if (!cvc.isRequest()) {
            CertificateExpirationDate cxd = cvc.getCVCertificate().getCertificateBody().getCertificateExpirationDate();
            Instant expiration = cxd.getLocalDate().atTime(12, 0, 0).atZone(ZoneId.of("Z")).toInstant();
            certDTO.setExpiry(Long.valueOf(expiration.toEpochMilli()));
        }
        if (cvc.getCertificationAuthorityReference().toString().equals(cvc.getCertificateHolderReference().toString())) {
            certDTO.setLinkDir(1);
        } else {
            certDTO.setLinkDir(0);
        }
        certDTO.setSerial(chr);
        return certDTO;
    }

    public void switchCertificate(Long certId) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            holderDAO.updateCurrentCertificate(certId, this.getId());
            this.currentCertificateDTO = null;
        }
    }

    public Long storeCertificate(CardVerifiableCertificate cvc, boolean makeCurrent, Long srId) {
        CertificateDTO certDTO = CVCertificateHolder.toCertificateDTO(cvc);
        certDTO.setHolderId(this.getId());
        certDTO.setServiceRequestId(srId);
        try (Handle handle = PKIDMContext.getJDBI().open();){
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            certDAO.create(certDTO);
            if (makeCurrent) {
                HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
                holderDAO.updateCurrentCertificate(certDTO.getId(), this.getId());
            }
        }
        return certDTO.getId();
    }

    public String generateLabel(String signerName) {
        Object path = "";
        CVCertificateHolder parent = this.getParent();
        if (parent != null) {
            path = parent.getPath().substring(1) + "/";
        }
        return (String)path + signerName;
    }

    public CVCSigner getSigner() {
        return this.getSigner(this.getCurrentKeyId());
    }

    public CVCSigner getSigner(byte[] keyId) {
        CVCSigner signer = this.getSigner(keyId, CVCSigner.class);
        signer.setLabel(this.generateLabel(signer.getName()));
        return signer;
    }

    public LinkedList<CardVerifiableCertificate> getCertificateChain() {
        CardVerifiableCertificate cvc = this.getCurrentCertificate();
        return this.getCertificateChain(cvc);
    }

    public LinkedList<CardVerifiableCertificate> getCertificateChain(CardVerifiableCertificate cvc) {
        CVCertificateHolder parent;
        LinkedList<CardVerifiableCertificate> chain = new LinkedList<CardVerifiableCertificate>();
        chain.add(cvc);
        if (parent == null) {
            return chain;
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            for (parent = this.getParent(); parent != null; parent = parent.getParent()) {
                CertificationAuthorityReference car = cvc.getAuthenticatedRequest() != null ? cvc.getOuterCertificationAuthorityReference() : cvc.getCertificationAuthorityReference();
                List certs = certDAO.getCertificateBySerial(parent.getId(), car.toString());
                if (certs.size() > 1) {
                    throw new RuntimeException("Certificate chain is not distinct for holder " + String.valueOf(this.getParent()));
                }
                if (certs.size() != 1) {
                    throw new RuntimeException("Issuer certificate " + car.toString() + " not found");
                }
                CertificateDTO cert = (CertificateDTO)certs.get(0);
                cvc = new CardVerifiableCertificate(cert.getBytes());
                chain.add(cvc);
            }
        }
        catch (CertificateException e) {
            throw new RuntimeException("Invalid certificate in database", e);
        }
        return chain;
    }

    public void checkAndFixKeyIdentifier() {
        CardVerifiableCertificate cvc = this.getCurrentCertificate();
        byte[] spki = cvc.getSubjectPublicKeyIdentifier();
        if (!Arrays.equals(spki, this.currentCertificateDTO.getKeyId())) {
            this.logger.info("Repairing key identifier for certificate " + this.currentCertificateDTO.getId());
            try (Handle handle = PKIDMContext.getJDBI().open();){
                CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
                certDAO.updateKeyId(spki, this.getId());
            }
        }
    }
}

