/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow.create;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.cert.CertPathBuilderException;
import opencard.core.OpenCardException;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkicard.cvc.CreateCVCSignerSmartCardHSMAction;
import org.openscdp.pkicard.escrow.create.CreateEscrowKeyContent;
import org.openscdp.pkicard.escrow.create.CreateEscrowKeySharedServiceRequest;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.cvc.importer.SCHSMTokenCertificateImporter;
import org.openscdp.pkidm.holder.escrow.KeyEscrowContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEscrowTargetKeyAction
extends CreateCVCSignerSmartCardHSMAction<CreateEscrowKeySharedServiceRequest> {
    private final Logger logger = LoggerFactory.getLogger(CreateEscrowTargetKeyAction.class);
    public static final String ACTION = "action.kess.createEscrow";
    private CreateEscrowKeyContent content;
    private Long groupSignerHolderId;

    public CreateEscrowTargetKeyAction(CreateEscrowKeySharedServiceRequest serviceRequest) {
        super(ACTION, serviceRequest);
    }

    public String getKey() {
        return ACTION;
    }

    @Override
    public boolean preFlightCheck() {
        this.content = ((CreateEscrowKeySharedServiceRequest)this.serviceRequest).getContent();
        this.keyDomainUID = this.content.keyDomain;
        if (this.keyDomainUID == null) {
            return false;
        }
        this.tokenPath = this.content.getTokenPath();
        if (this.tokenPath == null) {
            return false;
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            this.issuerId = dao.determineId(this.tokenPath, 1);
        }
        catch (Exception e) {
            this.logger.error("Invalid token path", (Throwable)e);
            return false;
        }
        if (this.issuerId == null) {
            return false;
        }
        this.groupSignerHolderId = this.content.groupSignerHolderId;
        if (this.groupSignerHolderId == null) {
            return false;
        }
        this.holderName = this.content.getHolderName();
        if (this.holderName == null && this.holderName.length() > 0) {
            return false;
        }
        this.existingKey = CreateCVCSignerSmartCardHSMAction.KeyHandling.DELETE;
        return true;
    }

    @Override
    protected void amendNewHolder(HolderDTO dto) {
        String jsonstr;
        dto.setSubjectId(((CreateEscrowKeySharedServiceRequest)this.serviceRequest).getRecipientId());
        dto.setType("KeyEscrow");
        KeyEscrowContent keContent = new KeyEscrowContent();
        keContent.groupSignerHolderId = this.groupSignerHolderId;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            jsonstr = om.writeValueAsString((Object)keContent);
        }
        catch (JsonProcessingException e) {
            throw new ServiceRequestActionException("Error setting content", (Throwable)e);
        }
        dto.setContent(jsonstr);
    }

    @Override
    protected void amendKeySpecification(SmartCardHSMPrivateKeySpec spec) {
        spec.setAlgorithmList(new byte[]{-124});
    }

    @Override
    protected String getCurve() {
        return "brainpoolP256r1";
    }

    @Override
    protected void postProcess() throws Exception {
        this.holder.storeCertificate(this.atreq, true, ((CreateEscrowKeySharedServiceRequest)this.serviceRequest).getId());
        this.content.keyEscrowHolderId = this.holder.getId();
        ((CreateEscrowKeySharedServiceRequest)this.serviceRequest).setStatusInfo("Signer and request generated");
        ((CreateEscrowKeySharedServiceRequest)this.serviceRequest).setLifeCycle(11);
        ((CreateEscrowKeySharedServiceRequest)this.serviceRequest).setRoleId(null);
    }

    @Override
    protected void postProcessForHSMServiceToken(SmartCardHSMProvider provider) {
        SCHSMTokenCertificateImporter importer = new SCHSMTokenCertificateImporter(((CreateEscrowKeySharedServiceRequest)this.serviceRequest).getBackendConnectedTo());
        try {
            importer.importDeviceChain(provider.getSmartCardHSMCardService());
        }
        catch (CertPathBuilderException | OpenCardException e) {
            this.logger.error("Signer creation failed", e);
            ((CreateEscrowKeySharedServiceRequest)this.serviceRequest).setStatusInfo("Creation failed");
            throw new ServiceRequestActionException(e.getMessage(), e);
        }
    }
}

