/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.factory;

import de.cardcontact.opencard.service.chv.AppletCHVCardService;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;

public class AppletCHVCardServiceFactory
extends CardServiceFactory {
    private static final byte[] BSEHB = new byte[]{-128, 49, -127, 84, 66, 83, 69, 49, 115, -128, 33, 64, -127, 7};
    public final int CARDTYPE = 2560;

    private static boolean partialMatch(byte[] hb, byte[] ref) {
        int i;
        if (hb.length < ref.length) {
            return false;
        }
        for (i = 0; i < ref.length && hb[i] == ref[i]; ++i) {
        }
        return i == ref.length;
    }

    @Override
    protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
        Vector<Class<AppletCHVCardService>> serviceClasses = new Vector<Class<AppletCHVCardService>>();
        byte[] hb = cid.getHistoricals();
        if (hb == null) {
            return CardType.UNSUPPORTED;
        }
        if (!AppletCHVCardServiceFactory.partialMatch(hb, BSEHB)) {
            return CardType.UNSUPPORTED;
        }
        serviceClasses.addElement(AppletCHVCardService.class);
        CardType cardType = new CardType(2560);
        cardType.setInfo(serviceClasses);
        return cardType;
    }

    @Override
    protected Enumeration getClasses(CardType type) {
        Vector serviceClasses = (Vector)type.getInfo();
        return serviceClasses.elements();
    }
}

