/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateBody;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.ECSignature;
import de.cardcontact.opencard.eac.cvc.Extension;
import de.cardcontact.opencard.eac.cvc.Extensions;
import de.cardcontact.opencard.eac.cvc.SignatureTLV;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.tlv.ObjectIdentifier;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;

public abstract class CVCGenerator {
    protected CertificationAuthorityReference car;
    protected CertificateHolderReference chr;
    protected ObjectIdentifier pubAlgo = ECPublicKeyTLV.id_TA_ECDSA_SHA_256;
    protected Extensions extensions = null;
    protected PublicKey pub;
    protected Provider provider;

    public void setCertificationAuthorityReference(CertificationAuthorityReference car) {
        this.car = car;
    }

    public void setPublicKey(PublicKey pub) {
        this.pub = pub;
    }

    public void setPublicKey(PublicKey pub, ObjectIdentifier algo) {
        this.pub = pub;
        this.pubAlgo = algo;
    }

    public void setCertificateHolderReference(CertificateHolderReference chr) {
        this.chr = chr;
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public void addExtension(Extension extension) {
        if (this.extensions == null) {
            this.extensions = new Extensions();
        }
        this.extensions.add(extension);
    }

    protected abstract CertificateBody getCertificateBody();

    protected byte[] sign(PrivateKey signerKey, String algo, byte[] data) throws GeneralSecurityException {
        Signature signer = this.provider != null ? Signature.getInstance(algo, this.provider) : Signature.getInstance(algo);
        signer.initSign(signerKey);
        signer.update(data);
        byte[] signature = signer.sign();
        if (signerKey instanceof ECKey) {
            int keysize;
            if (signerKey instanceof ECPrivateKey) {
                keysize = ((ECPrivateKey)signerKey).getParams().getCurve().getField().getFieldSize();
            } else if (signerKey instanceof SmartCardHSMKey) {
                keysize = ((SmartCardHSMKey)((Object)signerKey)).getKeySize();
            } else {
                throw new GeneralSecurityException("Failed to determine size of private key");
            }
            keysize = keysize + 7 >> 3;
            signature = ECSignature.unwrapSignature(signature, keysize);
        }
        return signature;
    }

    public CVCertificate generate(PrivateKey signerkey, String algo) throws GeneralSecurityException {
        CertificateBody body = this.getCertificateBody();
        if (this.extensions != null) {
            body.add(this.extensions);
        }
        byte[] signature = this.sign(signerkey, algo, body.getBytes());
        return new CVCertificate(body, new SignatureTLV(signature));
    }

    public CVCertificate generate(PrivateKey signerkey) throws GeneralSecurityException {
        return this.generate(signerkey, "SHA256withECDSA");
    }
}

