/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.form;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openscdp.pkidm.form.OptionGroupValue;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkidm.form.ValueField;

public class StringMultiSelectField
extends ValueField<List<String>> {
    public static String TYPE = "select";
    public List<SelectFieldValue> options = new LinkedList<SelectFieldValue>();
    public boolean multiselect = true;
    public String onchange;

    public StringMultiSelectField() {
        this(null, null, false, false);
    }

    public StringMultiSelectField(String id, String label, boolean editable, boolean required) {
        this(id, label, editable, null, false);
    }

    public StringMultiSelectField(String id, String label, boolean editable, List<String> value, boolean required) {
        super(id, label, TYPE, editable, value, false);
    }

    public void updateSelection(SelectValue sv) {
        if (this.value == null) {
            this.value = new LinkedList();
            if (sv.selected) {
                ((List)this.value).add(sv.value);
            }
        } else {
            if (sv.selected && ((List)this.value).contains(sv.value)) {
                throw new RuntimeException("Double selected option in single select field");
            }
            sv.selected = ((List)this.value).contains(sv.value);
        }
    }

    public void add(SelectFieldValue sfv) {
        if (sfv instanceof OptionGroupValue) {
            OptionGroupValue opt = (OptionGroupValue)sfv;
            for (SelectValue sv : opt.value) {
                this.updateSelection(sv);
            }
        } else {
            this.updateSelection((SelectValue)sfv);
        }
        this.options.add(sfv);
    }

    public void setValueFromIds(List<Long> values) {
        this.value = new ArrayList();
        for (SelectFieldValue option : this.options) {
            if (option instanceof SelectValue) {
                SelectValue sv = (SelectValue)option;
                sv.selected = values.contains(sv.id);
                if (!sv.selected) continue;
                ((List)this.value).add(sv.value);
                continue;
            }
            OptionGroupValue og = (OptionGroupValue)option;
            for (SelectValue sv : og.value) {
                sv.selected = values.contains(sv.id);
                if (!sv.selected) continue;
                ((List)this.value).add(sv.value);
            }
        }
    }

    @Override
    public void setValue(List<String> valueList) {
        this.value = new ArrayList();
        for (SelectFieldValue option : this.options) {
            if (option instanceof SelectValue) {
                SelectValue sv = (SelectValue)option;
                sv.selected = valueList.contains(sv.value);
                if (!sv.selected) continue;
                ((List)this.value).add(sv.value);
                continue;
            }
            OptionGroupValue og = (OptionGroupValue)option;
            for (SelectValue sv : og.value) {
                sv.selected = valueList.contains(sv.value);
                if (!sv.selected) continue;
                ((List)this.value).add(sv.value);
            }
        }
    }
}

