/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.est.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.openscdp.est.server.ESTServerContext;
import org.openscdp.pkidm.ApplicationContext;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.X509ServiceRequests;
import org.openscdp.pkidm.X509Subjects;

public class ESTServletContextListener
implements ServletContextListener {
    public static final String ATTRIBUTE_PKIDM = "PKIDM";
    Jdbi jdbi;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        String url = ctx.getInitParameter("database.url");
        String user = ctx.getInitParameter("database.user");
        String password = ctx.getInitParameter("database.password");
        Jdbi jdbi = Jdbi.create((String)url, (String)user, (String)password);
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        PKIDMContext.setJDBI((Jdbi)jdbi);
        X509ServiceRequests.addServiceRequestFactories((Jdbi)jdbi);
        X509Subjects.addSubjectFactories((Jdbi)jdbi);
        ESTServerContext estctx = new ESTServerContext();
        PKIDMContext.setApplicationContext((ApplicationContext)estctx);
        String estid = ctx.getInitParameter("service.id");
        String pkiaasurl = ctx.getInitParameter("service.pkiaasurl");
        estctx.configure(Long.valueOf(estid), pkiaasurl);
        ctx.setAttribute(ATTRIBUTE_PKIDM, (Object)PKIDMContext.getInstance());
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        PKIDMContext pkidmctx = (PKIDMContext)ctx.getAttribute(ATTRIBUTE_PKIDM);
        if (pkidmctx != null) {
            ctx.removeAttribute(ATTRIBUTE_PKIDM);
        }
    }
}

