/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.est.server;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.est.server.ESTRequestBase;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;

public class ESTGetCACertificates
extends ESTRequestBase {
    ESTGetCACertificates(HttpServletRequest req, HttpServletResponse resp, String label) {
        super(req, resp, label);
    }

    private void buildChain(ArrayList<Long> certids, Long holderId, byte[] keyid) throws IOException {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            List dtos;
            HolderDAO hdao = (HolderDAO)handle.attach(HolderDAO.class);
            HolderDTO holder = hdao.getHolder(holderId);
            CertificateDAO cdao = (CertificateDAO)handle.attach(CertificateDAO.class);
            Long certId = null;
            X509CertificateHolder cert = null;
            if (keyid != null && !(dtos = cdao.getCertificateByHolderAndKeyId(holderId, keyid)).isEmpty()) {
                certId = ((CertificateDTO)dtos.get(0)).getId();
                cert = new X509CertificateHolder(((CertificateDTO)dtos.get(0)).getBytes());
            }
            if (certId == null) {
                certId = holder.getCertId();
                if (certId == null) {
                    this.reportError(500, "Could not build a certificate chain");
                    return;
                }
                CertificateDTO certdto = cdao.getCertificate(certId);
                cert = new X509CertificateHolder(certdto.getBytes());
            }
            if (holder.getParentId() != null) {
                AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.fromExtensions((Extensions)cert.getExtensions());
                byte[] nkeyid = aki.getKeyIdentifier();
                this.buildChain(certids, holder.getParentId(), nkeyid);
            }
            if (!certids.contains(certId)) {
                this.certs.add(cert);
                certids.add(certId);
            }
        }
    }

    private void collectCertificates() throws IOException {
        ArrayList<Long> certids = new ArrayList<Long>();
        List issuerIds = this.trustCenterConfig.getIssuerIds();
        for (Long id : issuerIds) {
            this.buildChain(certids, id, null);
        }
    }

    @Override
    public void handleRequest() throws IOException {
        if (!this.isValidLabel()) {
            return;
        }
        if (!this.hasTrustCenterJoined()) {
            return;
        }
        this.collectCertificates();
        this.returnCertificates();
    }
}

