/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb;

import java.lang.reflect.Field;
import java.util.Objects;

public class Order {
    private String orderBy;
    private boolean asc;

    public Order(String orderBy, boolean asc) {
        this.orderBy = orderBy;
        this.asc = asc;
    }

    public boolean validateOrderBy(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getName().equals(this.orderBy)) continue;
            return true;
        }
        return false;
    }

    public String getValue() {
        if (this.asc) {
            return this.orderBy + " ASC";
        }
        return this.orderBy + " DESC";
    }

    public String toString() {
        return "Order [orderBy=" + this.orderBy + ", asc=" + this.asc + "]";
    }

    public int hashCode() {
        return Objects.hash(this.asc, this.orderBy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return this.asc == other.asc && Objects.equals(this.orderBy, other.orderBy);
    }
}

