/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.groupsigner;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.util.List;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.groupsigner.CreateGroupSharedServiceRequest;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumerateKeyDomains
extends ServiceRequestSmartCardHSMAction {
    public static final String ACTION = "action.kess.enumeratekeydomains";
    private final Logger logger = LoggerFactory.getLogger(EnumerateKeyDomains.class);
    private CreateGroupSharedServiceRequest serviceRequest;

    public EnumerateKeyDomains(CreateGroupSharedServiceRequest serviceRequest) {
        super(ACTION, (ServiceRequest)serviceRequest);
        this.serviceRequest = serviceRequest;
        String lastSeenAt = serviceRequest.getBackendConnectedTo();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    @Override
    public JSONActionResult execute() {
        String lastSeenAt = this.serviceRequest.getBackendConnectedTo();
        if (lastSeenAt == null) {
            return this.getStatus();
        }
        return this.execute(this.serviceRequest.getTokenPath());
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        try {
            SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
            if (!service.getId().equals(this.serviceRequest.getTokenPath())) {
                throw new ServiceRequestActionException("Wrong Token presented");
            }
            byte[] defaultKDUID = service.getDefaultKeyDomainUID();
            List keyDomains = service.getKeyDomains();
            this.serviceRequest.setKeyDomains(defaultKDUID, keyDomains);
        }
        catch (ServiceRequestActionException srae) {
            throw srae;
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

