/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow.receive;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.TLVEncodingException;
import java.security.Key;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import opencard.core.OpenCardException;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.escrow.SmartCardHSMCertificateChainTLV;
import org.openscdp.pkicard.escrow.XKEKKeyDomain;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowSharedServiceRequest;
import org.openscdp.pkidb.dao.KeyEscrowDAO;
import org.openscdp.pkidb.dto.KeyEscrowDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.cvc.CVCSigner;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewrapKeyForReceiverAction
extends ServiceRequestSmartCardHSMAction {
    private final Logger logger = LoggerFactory.getLogger(RewrapKeyForReceiverAction.class);
    public static final String ACTION = "action.kess.rewrapforreceiver";
    private ReceiveKeyFromEscrowSharedServiceRequest serviceRequest;
    private XKEKKeyDomain escrowXKD;
    private List<Long> keysToImport;
    private String tokenPath;
    private byte[] keyDomain;
    private byte[] escrowKeyId;

    public RewrapKeyForReceiverAction(ReceiveKeyFromEscrowSharedServiceRequest serviceRequest) {
        super(ACTION, (ServiceRequest)serviceRequest);
        this.serviceRequest = serviceRequest;
        String lastSeenAt = serviceRequest.getBackendEscrowConnectedTo();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    public String getKey() {
        return ACTION;
    }

    public ServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean preFlightCheck() {
        try {
            this.tokenPath = this.serviceRequest.getKeyEscrowHolder().getTokenPath();
        }
        catch (Exception e) {
            return false;
        }
        CVCSigner signer = this.serviceRequest.getKeyEscrowHolder().getSigner();
        if (signer == null) {
            return false;
        }
        this.keyDomain = signer.getKeyDomain();
        this.escrowKeyId = signer.getKeyId();
        this.keysToImport = this.serviceRequest.getContent().keysToImport;
        return this.keysToImport != null && this.keysToImport.size() != 0;
    }

    protected void assertReady(SmartCardHSMProvider provider) {
        if (!this.preFlightCheck()) {
            throw new ServiceRequestActionException("Precondition for service request not fulfilled");
        }
        SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
        try {
            if (!service.getId().equals(this.tokenPath)) {
                throw new ServiceRequestActionException("Wrong Token presented");
            }
            if (service.getPasswordStatus(null, 1) != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                throw new ServiceRequestActionException("Escrow Token " + this.serviceRequest.getKeyEscrowHolder().getName() + " is not authenticated");
            }
        }
        catch (CertPathBuilderException | OpenCardException e) {
            this.logger.error("Device error", e);
            throw new ServiceRequestActionException("Error while processing token " + this.tokenPath, e);
        }
        this.escrowXKD = new XKEKKeyDomain(provider, this.keyDomain);
        SmartCardHSMPrivateKey escrowKey = (SmartCardHSMPrivateKey)this.escrowXKD.getKey(this.escrowKeyId);
        if (escrowKey == null) {
            throw new ServiceRequestActionException("Escrow key not found");
        }
        this.escrowXKD.setEphemeralKey(escrowKey);
    }

    private boolean isEscrowTokenReceiver() {
        return this.serviceRequest.getContent().getTokenPath().equals(this.tokenPath);
    }

    private void processKeyEscrow(Long id, boolean receiveOnEscrowToken) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            KeyEscrowDAO escrowDAO = (KeyEscrowDAO)handle.attach(KeyEscrowDAO.class);
            KeyEscrowDTO dto = escrowDAO.getKeyEscrow(id);
            SmartCardHSMKey targetKey = this.escrowXKD.getKey(dto.getKeyId());
            boolean deleteAfterWrap = false;
            if (targetKey == null) {
                deleteAfterWrap = true;
                SmartCardHSMCertificateChainTLV chain = new SmartCardHSMCertificateChainTLV(dto.getExportCertificateChain());
                this.escrowXKD.deriveXKEKWith(chain);
                targetKey = this.escrowXKD.unwrapKey(dto.getKeyblob());
            }
            if (!receiveOnEscrowToken) {
                this.rewrapForReceiver(targetKey, deleteAfterWrap);
            }
        }
        catch (TLVEncodingException e) {
            this.logger.error("Rewrapping key failed", (Throwable)e);
            throw new ServiceRequestActionException("Rewrapping key failed", (Throwable)e);
        }
    }

    private void rewrapForReceiver(SmartCardHSMKey targetKey, boolean deleteAfterWrap) {
        SmartCardHSMCertificateChainTLV exchangeChain = this.serviceRequest.getExchangeChain();
        this.escrowXKD.deriveXKEKWith(exchangeChain);
        byte[] wrappedKey = this.escrowXKD.wrapKey((Key)targetKey);
        if (this.serviceRequest.getContent().keyblobs == null) {
            this.serviceRequest.getContent().keyblobs = new ArrayList<String>(this.serviceRequest.getContent().keysToImport.size());
        }
        this.serviceRequest.getContent().keyblobs.add(HexString.hexifyByteArray((byte[])wrappedKey));
        if (deleteAfterWrap) {
            this.escrowXKD.deleteKey(targetKey);
        }
    }

    private void deleteExchangeKey() {
        try {
            SmartCardHSMCertificateChainTLV exchangeChain = this.serviceRequest.getExchangeChain();
            CardVerifiableCertificate exchangeCert = exchangeChain.getCertificate();
            SmartCardHSMPrivateKey exchangeKey = (SmartCardHSMPrivateKey)this.escrowXKD.getKey(exchangeCert.getSubjectPublicKeyIdentifier());
            if (exchangeKey != null) {
                this.escrowXKD.deleteKey((SmartCardHSMKey)exchangeKey);
            }
        }
        catch (TLVEncodingException | CertificateException e) {
            this.logger.error("Invalid encoding", e);
            throw new ServiceRequestActionException("Invalid encoding", e);
        }
    }

    @Override
    public JSONActionResult execute() {
        String lastSeenAt = this.serviceRequest.getBackendEscrowConnectedTo();
        if (lastSeenAt == null) {
            return this.getStatus();
        }
        try {
            this.tokenPath = this.serviceRequest.getKeyEscrowHolder().getTokenPath();
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
        return this.execute(this.tokenPath);
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        try {
            this.assertReady(provider);
            boolean receiveOnEscrowToken = this.isEscrowTokenReceiver();
            for (Long id : this.keysToImport) {
                this.processKeyEscrow(id, receiveOnEscrowToken);
            }
            if (receiveOnEscrowToken) {
                this.deleteExchangeKey();
                this.serviceRequest.setStatusInfo("Received key on escrow");
                this.serviceRequest.setLifeCycle(11);
            } else {
                this.serviceRequest.setStatusInfo("Rewrapped for receiver");
                this.serviceRequest.setLifeCycle(6);
            }
            this.serviceRequest.setRoleId(null);
        }
        catch (ServiceRequestActionException srae) {
            throw srae;
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

