/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkiapi;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.LinkedList;
import java.util.List;
import org.openscdp.pkidb.Filter;
import org.openscdp.pkidb.Order;

public class QuerySpec {
    public static final String KEY_LIMIT = "limit";
    public static final String KEY_OFFSET = "offset";
    public static final String KEY_ORDER_BY = "sort_by";
    public static final String ORDER_ASC = "asc";
    public static final String ORDER_DESC = "desc";
    private Long limit = null;
    private Long offset;
    private List<Order> orderBy;
    private List<Filter> filters;

    public QuerySpec(MultivaluedMap<String, String> params) {
        List l;
        if (params.containsKey((Object)KEY_LIMIT)) {
            l = (List)params.get((Object)KEY_LIMIT);
            this.limit = Long.valueOf((String)l.get(0));
        }
        if (params.containsKey((Object)KEY_OFFSET)) {
            l = (List)params.get((Object)KEY_OFFSET);
            this.offset = Long.valueOf((String)l.get(0));
        }
        this.orderBy = new LinkedList<Order>();
        if (params.containsKey((Object)KEY_ORDER_BY)) {
            for (String s : (List)params.get((Object)KEY_ORDER_BY)) {
                this.orderBy.add(this.parseOrder(s));
            }
        }
        this.filters = new LinkedList<Filter>();
        block9: for (String key : params.keySet()) {
            switch (key) {
                case "limit": 
                case "offset": 
                case "sort_by": {
                    continue block9;
                }
            }
            for (String opAndValue : (List)params.get((Object)key)) {
                this.filters.add(this.parseFilter(key, opAndValue));
            }
        }
    }

    public Long getLimit() {
        return this.limit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public List<Order> getOrderBy() {
        return this.orderBy;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    private Filter parseFilter(String key, String opAndValue) {
        int idx = opAndValue.indexOf(":");
        String opStr = opAndValue.substring(0, idx);
        Filter.OPERATOR op = Filter.OPERATOR.valueOf((String)opStr);
        String value = opAndValue.substring(idx + 1);
        return new Filter(key, (Object)value, op);
    }

    private Order parseOrder(String s) {
        String sortBy;
        int idx = s.indexOf(":");
        String order = null;
        if (idx >= 0) {
            sortBy = s.substring(0, idx);
            order = s.substring(idx + 1);
        } else {
            sortBy = s;
        }
        boolean asc = order == null || order.equals(ORDER_ASC);
        return new Order(sortBy, asc);
    }
}

