/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow.send;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkicard.escrow.send.EnumerateKeysAction;
import org.openscdp.pkicard.escrow.send.SendKeyToEscrowAction;
import org.openscdp.pkicard.escrow.send.SendKeyToEscrowContent;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestSaveAction;
import org.openscdp.pkidm.holder.escrow.KeyEscrow;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendKeyToEscrowSharedServiceRequest
extends ServiceRequestBase {
    public static final String PROCESS = "SendKeyToEscrow";
    private final Logger logger = LoggerFactory.getLogger(SendKeyToEscrowSharedServiceRequest.class);
    private KeyEscrow keyEscrowHolder;
    private SendKeyToEscrowContent content;

    public SendKeyToEscrowSharedServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public KeyEscrow getKeyEscrowHolder() {
        if (this.keyEscrowHolder == null) {
            try (Handle handle = PKIDMContext.getJDBI().open();){
                HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
                HolderDTO holder = dao.getHolder(this.getContent().keyEscrowHolderId);
                this.keyEscrowHolder = new KeyEscrow(holder);
            }
        }
        return this.keyEscrowHolder;
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        if (action.action.equals("action.save")) {
            return new ServiceRequestSaveAction((ServiceRequest)this);
        }
        if (action.action.equals("action.kess.enumeratekeys")) {
            return new EnumerateKeysAction(this);
        }
        if (action.action.equals("action.kess.sendtoescrow")) {
            return new SendKeyToEscrowAction(this);
        }
        return null;
    }

    public SendKeyToEscrowContent getContent() {
        if (this.content == null) {
            this.content = (SendKeyToEscrowContent)this.getContentView(SendKeyToEscrowContent.class);
        }
        return this.content;
    }

    public String getBackendConnectedTo() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO dto = dao.getToken(this.getContent().getTokenPath());
            if (dto.getOnline() == 0L) {
                String string = null;
                return string;
            }
            String string = dto.getLastSeenAt();
            return string;
        }
    }
}

