/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.kdm;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembership;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembershipContent;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateKeyDomainAction
extends ServiceRequestSmartCardHSMAction {
    public static final String ACTION = "action.kess.kdm.createkd";
    private final Logger logger = LoggerFactory.getLogger(CreateKeyDomainAction.class);

    public CreateKeyDomainAction(IssueKeyDomainMembership serviceRequest) {
        super(ACTION, serviceRequest);
        String lastSeenAt = serviceRequest.getBackendConnectedTo();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    protected void createKeyDomain(SmartCardHSMProvider provider) throws Exception {
        IssueKeyDomainMembership sr = (IssueKeyDomainMembership)this.serviceRequest;
        IssueKeyDomainMembershipContent content = sr.getContent();
        SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
        String id = service.getId();
        if (!id.equals(sr.getContent().tokenPath)) {
            throw new ServiceRequestActionException("Wrong Token presented");
        }
        byte[] uid = HexString.parseHexString((String)content.keyDomainUID);
        List kdList = service.getKeyDomains();
        KeyDomain keyDomain = null;
        for (KeyDomain kd : kdList) {
            if (Arrays.compare(uid, kd.getKeyDomainUID()) == 0) {
                this.logger.info("Key domain does already exist");
                return;
            }
            if (kd.isCreated()) continue;
            keyDomain = kd;
        }
        if (keyDomain == null) {
            throw new ServiceRequestActionException("No free key domain on token");
        }
        LinkedList chain = sr.getGroupMember().getParent().getCertificateChain();
        CardVerifiableCertificate gsCert = (CardVerifiableCertificate)chain.get(0);
        CardVerifiableCertificate[] chainArray = chain.toArray(new CardVerifiableCertificate[0]);
        service.verifyCertificateChain(chainArray);
        byte[] kdm = HexString.parseHexString((String)content.keyDomainMembership);
        service.createXKEKKeyDomain(keyDomain, gsCert, kdm);
    }

    @Override
    public JSONActionResult execute() {
        IssueKeyDomainMembership sr = (IssueKeyDomainMembership)this.serviceRequest;
        String lastSeenAt = sr.getBackendConnectedTo();
        if (lastSeenAt == null) {
            return this.getStatus();
        }
        return this.execute(sr.getContent().getTokenPath());
    }

    @Override
    protected void postProcessForHSMServiceToken(SmartCardHSMProvider provider) {
        HSMService hsmService = PKIDMContext.getHSMService();
        IssueKeyDomainMembership sr = (IssueKeyDomainMembership)this.serviceRequest;
        byte[] uid = HexString.parseHexString((String)sr.getContent().keyDomainUID);
        String id = null;
        try {
            id = provider.getSmartCardHSMCardService().getId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        hsmService.addKeyDomainMapping(uid, id);
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        try {
            this.createKeyDomain(provider);
            this.setDetail("Key Domain created");
            this.serviceRequest.setStatusInfo(this.getDetail());
            this.serviceRequest.setLifeCycle(11);
            this.serviceRequest.setRoleId(null);
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

