/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.GPKeyDerivation;
import de.cardcontact.opencard.security.GPKeySet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DESKeyDerivation
extends GPKeyDerivation {
    private SecretKey key;
    private Cipher desCipher;

    public DESKeyDerivation(SecretKey key) {
        this.key = key;
        try {
            this.desCipher = Cipher.getInstance("DESede/ECB/NoPadding");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create cipher instance", e);
        }
    }

    private static void adjustParity(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            int akku = key[i] & 0xFF | 1;
            for (int c = 7; c > 0; --c) {
                akku = akku & 1 ^ akku >> 1;
            }
            key[i] = (byte)(key[i] & 0xFE | akku);
        }
    }

    public byte[] deriveData(byte ddc, byte[] context) {
        byte[] res;
        ByteBuffer bb = ByteBuffer.allocate(256);
        bb.put(context, context.length - 6, 6);
        bb.put((byte)-16);
        bb.put(ddc);
        bb.put(context, context.length - 6, 6);
        bb.put((byte)15);
        bb.put(ddc);
        bb.flip();
        byte[] input = new byte[bb.remaining()];
        bb.get(input);
        try {
            this.desCipher.init(1, this.key);
            res = this.desCipher.doFinal(input);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to derive keys", e);
        }
        DESKeyDerivation.adjustParity(res);
        return res;
    }

    @Override
    public GPKeySet deriveGPKeys(byte version, byte[] keyDiversificationData) {
        byte[] encval = this.deriveData((byte)1, keyDiversificationData);
        byte[] macval = this.deriveData((byte)2, keyDiversificationData);
        byte[] dekval = this.deriveData((byte)3, keyDiversificationData);
        GPKeySet key = new GPKeySet(version, new SecretKeySpec(encval, "DESede"), new SecretKeySpec(macval, "DESede"), new SecretKeySpec(dekval, "DESede"));
        Arrays.fill(encval, (byte)0);
        Arrays.fill(macval, (byte)0);
        Arrays.fill(dekval, (byte)0);
        return key;
    }
}

