/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.est.server;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.openscdp.est.server.ESTEnrollRequest;
import org.openscdp.est.server.ESTGetCACertificates;
import org.openscdp.est.server.ESTReenrollRequest;
import org.openscdp.est.server.LabelAndOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESTServlet
extends HttpServlet {
    final Logger logger = LoggerFactory.getLogger(ESTServlet.class);

    private LabelAndOperation validatePathInfo(HttpServletRequest req) {
        String pi = req.getPathInfo();
        if (pi == null) {
            this.logger.error("Request does not specify an operation");
            return null;
        }
        LabelAndOperation lo = new LabelAndOperation(pi);
        if (!lo.isValid()) {
            return null;
        }
        return lo;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LabelAndOperation lo = this.validatePathInfo(req);
        if (lo == null) {
            resp.sendError(404, "Operation or label invalid");
            return;
        }
        switch (lo.getOperation()) {
            case 0: {
                resp.sendError(403, "cacerts option not allowed via POST");
                return;
            }
            case 1: {
                ESTEnrollRequest enreq = new ESTEnrollRequest(req, resp, lo.getLabel());
                enreq.handleRequest();
                break;
            }
            case 2: {
                ESTReenrollRequest renreq = new ESTReenrollRequest(req, resp, lo.getLabel());
                renreq.handleRequest();
                break;
            }
            default: {
                resp.sendError(501, "Operation not supported");
                return;
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LabelAndOperation lo = this.validatePathInfo(req);
        if (lo == null) {
            resp.sendError(404, "Operation or label invalid");
            return;
        }
        switch (lo.getOperation()) {
            case 0: {
                ESTGetCACertificates getcareq = new ESTGetCACertificates(req, resp, lo.getLabel());
                getcareq.handleRequest();
                break;
            }
            case 1: 
            case 2: {
                resp.sendError(403, "Enrollment not allowed via GET");
                return;
            }
            default: {
                resp.sendError(501, "Operation not supported");
                return;
            }
        }
    }
}

