/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.x509.action;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.List;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.HexString;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestActionStates;
import org.openscdp.pkidm.holder.X509CertificateHolder;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateError;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CreateX509SignerAction<T extends ServiceRequest>
implements ServiceRequestAction {
    private final Logger logger = LoggerFactory.getLogger(CreateX509SignerAction.class);
    protected T serviceRequest;
    protected String tokenPath;
    protected byte[] keyDomainUID;
    protected SmartCardHSMProvider provider;
    private KeyStore keyStore;
    private String signername;
    private String label;
    protected KeyHandling existingKey = KeyHandling.FAIL;
    protected Long issuerId;
    protected Long holderId;
    protected String holderName;
    protected X509CertificateHolder holder;
    private int signerNo;
    protected SignerDTO signerDTO;
    protected Certificate atreq;

    public CreateX509SignerAction(T serviceRequest) {
        this.serviceRequest = serviceRequest;
    }

    @Override
    public ServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean isReady() {
        HSMService hsmService = PKIDMContext.getHSMService();
        this.provider = hsmService.getProvider(this.tokenPath);
        if (this.provider == null) {
            this.serviceRequest.setActionInfo("Token " + this.tokenPath + " is not connected");
            return false;
        }
        try {
            if (this.provider.getSmartCardHSMCardService().getPasswordStatus(null, 1) != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                this.serviceRequest.setActionInfo("Token " + this.tokenPath + " is not authenticated");
                return false;
            }
        }
        catch (CardServiceException | CardTerminalException e) {
            this.logger.error("Device error", e);
            this.serviceRequest.setActionInfo("Error while processing token " + this.tokenPath + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    protected void amendNewHolder(HolderDTO dto) {
    }

    protected boolean amendExistingHolder(HolderDTO dto) {
        return false;
    }

    private HolderDTO createHolder() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            HolderDTO dto = new HolderDTO();
            dto.setParentId(this.issuerId);
            dto.setCertificateType(2);
            dto.setName(this.holderName);
            this.amendNewHolder(dto);
            HolderDTO holderDTO = dao.create(dto);
            return holderDTO;
        }
    }

    protected X509CertificateHolder getHolder() {
        HolderDAO dao;
        if (this.holder != null) {
            return this.holder;
        }
        HolderDTO dto = null;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            dao = (HolderDAO)handle.attach(HolderDAO.class);
            if (this.holderId == null || this.holderId <= 0L) {
                this.holderId = this.issuerId == null ? dao.getRootHolderId(2, this.holderName) : dao.getHolderId(2, this.issuerId, this.holderName);
            }
            if (this.holderId != null && this.holderId > 0L) {
                dto = dao.getHolder(this.holderId);
            }
        }
        if (dto == null) {
            dto = this.createHolder();
        } else if (this.amendExistingHolder(dto)) {
            handle = PKIDMContext.getJDBI().open();
            try {
                dao = (HolderDAO)handle.attach(HolderDAO.class);
                dao.updateSubjectId(dto.getSubjectId(), dto.getId());
                dao.updateContent(dto.getContent(), dto.getId());
                dao.updateType(dto.getType(), dto.getId());
            }
            finally {
                if (handle != null) {
                    handle.close();
                }
            }
        }
        this.holderId = dto.getId();
        this.holder = new X509CertificateHolder(dto);
        return this.holder;
    }

    protected String getCurve() {
        throw new RuntimeException("Base class can not provide domain parameter");
    }

    protected void amendKeySpecification(SmartCardHSMPrivateKeySpec spec) {
    }

    protected String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        this.signername = this.getSignerNo() > 1 ? this.holder.getName() + "-" + this.getSignerNo() : this.holder.getName();
        this.label = this.signername;
        for (X509CertificateHolder parent = this.holder.getParent(); parent != null; parent = parent.getParent()) {
            this.label = parent.getName() + "/" + this.label;
        }
        return this.label;
    }

    protected SmartCardHSMParameterSpec getKeySpec() throws OpenCardException {
        SmartCardHSMCardService service;
        SmartCardHSMECPrivateKeySpec spec = new SmartCardHSMECPrivateKeySpec((AlgorithmParameterSpec)new ECGenParameterSpec(this.getCurve()));
        if (this.keyDomainUID != null && !Arrays.equals(this.keyDomainUID, (service = this.provider.getSmartCardHSMCardService()).getDefaultKeyDomainUID())) {
            boolean found = false;
            List keyDomains = service.getKeyDomains();
            for (KeyDomain kd : keyDomains) {
                if (!kd.isCreated() || !Arrays.equals(this.keyDomainUID, kd.getKeyDomainUID())) continue;
                spec.setKeyDomain(kd);
                found = true;
                break;
            }
            if (!found) {
                throw new CardServiceException("Could not located key domain " + HexString.hexify((byte[])this.keyDomainUID));
            }
        }
        String label = this.getLabel();
        this.amendKeySpecification((SmartCardHSMPrivateKeySpec)spec);
        SmartCardHSMParameterSpec hsmParam = new SmartCardHSMParameterSpec(label, (SmartCardHSMKeySpec)spec);
        return hsmParam;
    }

    private int getSignerNo() {
        if (this.signerNo == 0) {
            this.signerNo = this.holder.countSigner() + 1;
        }
        return this.signerNo;
    }

    protected void ammendNewSigner(SignerDTO dto) {
    }

    protected void generateSignerKeyPair() throws Exception {
        CardVerifiableCertificate cvc;
        KeyDomain kd;
        this.getHolder();
        this.keyStore = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)this.provider);
        this.keyStore.load(null, null);
        SmartCardHSMPrivateKey prk = null;
        if (this.keyStore.containsAlias(this.getLabel())) {
            if (this.existingKey == KeyHandling.FAIL) {
                throw new CardServiceException("A key with label " + this.getLabel() + " does already exist");
            }
            if (this.existingKey == KeyHandling.DELETE) {
                this.keyStore.deleteEntry(this.getLabel());
                this.logger.info("Existing key " + this.getLabel() + " on hsm removed");
            } else {
                Key key = this.keyStore.getKey(this.getLabel(), null);
                if (!(key instanceof SmartCardHSMPrivateKey)) {
                    throw new CardServiceException("Existing key with label " + this.getLabel() + " is not a asymmetric key");
                }
                prk = (SmartCardHSMPrivateKey)key;
            }
        } else if (this.existingKey == KeyHandling.REUSE) {
            throw new CardServiceException("A key with label " + this.getLabel() + " does not exist");
        }
        if (prk == null) {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)this.provider);
            SmartCardHSMParameterSpec spec = this.getKeySpec();
            kpg.initialize((AlgorithmParameterSpec)spec, null);
            KeyPair kp = kpg.generateKeyPair();
            prk = (SmartCardHSMPrivateKey)kp.getPrivate();
        }
        byte[] keyDomain = (kd = prk.getKeyDomain()) == null ? this.provider.getSmartCardHSMCardService().getDefaultKeyDomainUID() : kd.getKeyDomainUID();
        byte[] keyId = prk.getKeyId();
        this.atreq = this.keyStore.getCertificate(this.getLabel());
        if (this.atreq == null) {
            throw new CardServiceException("The key with label " + this.getLabel() + " does not have a public key");
        }
        if (this.atreq instanceof CardVerifiableCertificate && !Arrays.equals(keyId, (cvc = (CardVerifiableCertificate)this.atreq).getSubjectPublicKeyIdentifier())) {
            this.logger.warn("Key identifier does not match subject public key identifier, changing key identifier.");
            keyId = cvc.getSubjectPublicKeyIdentifier();
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            SignerDAO sdao = (SignerDAO)handle.attach(SignerDAO.class);
            this.signerDTO = new SignerDTO(Long.valueOf(0L), this.holder.getId(), this.signername, keyId, keyDomain, (byte[])null, null);
            this.ammendNewSigner(this.signerDTO);
            sdao.create(this.signerDTO);
            HolderDAO hdao = (HolderDAO)handle.attach(HolderDAO.class);
            hdao.updateSignerNo(Long.valueOf(this.getSignerNo()), this.holder.getId());
        }
        this.serviceRequest.updateDetails(this.getLabel());
    }

    protected void storeCertificate(X509Certificate cert) throws KeyStoreException {
        this.keyStore.setCertificateEntry(this.getLabel(), cert);
    }

    protected ServiceRequestStateContent postProcess() throws Exception {
        return null;
    }

    @Override
    public JSONActionResult execute() {
        try {
            if (!this.isReady()) {
                String status = this.serviceRequest.getActionInfo();
                if (status == null) {
                    status = "Precondition for service request not fulfilled";
                }
                throw new ServiceRequestActionException(status);
            }
            this.generateSignerKeyPair();
            ServiceRequestStateContent content = this.postProcess();
            this.serviceRequest.commit(content);
        }
        catch (Exception e) {
            this.logger.error("Signer creation failed", (Throwable)e);
            this.serviceRequest.setStatusInfo("Creation failed");
            this.serviceRequest.commit(new ServiceRequestStateError(e.getMessage()));
            return new JSONActionResult(ServiceRequestActionStates.FAILED, e.getMessage());
        }
        return new JSONActionResult(ServiceRequestActionStates.COMPLETED, "Signer created");
    }

    protected static enum KeyHandling {
        FAIL,
        DELETE,
        USE,
        REUSE;

    }
}

