/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.UTF8String;

public class KeyDomainDescription {
    private byte[] encoded;
    private String label;

    public KeyDomainDescription(String label) {
        this.label = label;
    }

    public KeyDomainDescription(byte[] desc) throws TLVEncodingException {
        this.encoded = desc;
        this.parseEncoded();
    }

    private void parseEncoded() throws TLVEncodingException {
        ConstructedTLV tlv = (ConstructedTLV)TLV.factory(this.encoded);
        Sequence seq = Sequence.getInstance(tlv.get(0));
        this.label = UTF8String.getInstance(seq.get(0)).toString();
    }

    public String getLabel() {
        return this.label;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            ConstructedTLV desc = new Sequence().add(new Sequence().add(new UTF8String(this.label)));
            this.encoded = desc.getBytes();
        }
        return this.encoded;
    }
}

