/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.est.server;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cmc.SimplePKIResponse;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.est.server.ESTServerContext;
import org.openscdp.est.server.SimplePKIResponseGenerator;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.est.ESTServer;
import org.openscdp.pkidm.est.JoinESTServerServiceRequest;
import org.openscdp.pkidm.subject.TrustCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ESTRequestBase {
    final Logger logger = LoggerFactory.getLogger(ESTRequestBase.class);
    public static final String TLS_CERT_HEADER = "X-TLS-Client-Certificate";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APPLICATION_PKCS10 = "application/pkcs10";
    public static final String APPLICATION_PKCS7 = "application/pkcs7-mime; smime-type=certs-only";
    HttpServletRequest req;
    HttpServletResponse resp;
    String label;
    TrustCenter trustCenter;
    JoinESTServerServiceRequest trustCenterConfig;
    List<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>();

    ESTRequestBase(HttpServletRequest req, HttpServletResponse resp, String label) {
        this.req = req;
        this.resp = resp;
        this.label = label;
    }

    void reportError(int code, String msg) throws IOException {
        this.logger.error(msg);
        this.resp.setStatus(code);
        this.resp.setContentType(TEXT_PLAIN);
        this.resp.getWriter().println(msg);
    }

    boolean isValidLabel() throws IOException {
        SubjectDTO dto;
        if (this.label.isEmpty()) {
            this.trustCenter = this.getESTServer().getOwningTrustCenter();
            return true;
        }
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
            dto = dao.getSubject("TrustCenter", this.label);
        }
        if (dto == null) {
            this.reportError(404, "Label does not reference a trust center");
            return false;
        }
        this.trustCenter = (TrustCenter)PKIDMContext.getSubjectFactoryRegistry().getByDTO(dto, TrustCenter.class);
        return true;
    }

    ESTServer getESTServer() {
        return ((ESTServerContext)PKIDMContext.getApplicationContext()).getESTServer();
    }

    boolean hasTrustCenterJoined() throws IOException {
        ServiceRequestDTO dto;
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dto = dao.getServiceRequestLink(this.trustCenter.getId(), this.getESTServer().getId(), "JoinESTServerServiceRequest");
        }
        if (dto == null) {
            this.reportError(404, "Trust center does not serve on this EST server");
            return false;
        }
        this.trustCenterConfig = (JoinESTServerServiceRequest)PKIDMContext.getServiceRequestFactoryRegistry().getByDTO(dto);
        return true;
    }

    void returnCertificates() throws IOException {
        SimplePKIResponseGenerator pkirespgen = new SimplePKIResponseGenerator();
        for (X509CertificateHolder cert : this.certs) {
            pkirespgen.addCertificate(cert);
        }
        SimplePKIResponse pkiresp = pkirespgen.generate();
        byte[] pkirespbin = pkiresp.getEncoded();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int blen = 48;
        byte[] tmp = new byte[blen];
        for (int i = 0; i < pkirespbin.length; i += blen) {
            System.arraycopy(pkirespbin, i, tmp, 0, pkirespbin.length - i < blen ? pkirespbin.length - i : blen);
            baos.write(Base64.getEncoder().encode(tmp));
            baos.write(10);
        }
        this.resp.setContentType(APPLICATION_PKCS7);
        this.resp.setContentLength(baos.size());
        ServletOutputStream out = this.resp.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.close();
    }

    int pingService(Long srid) {
        int rc = 202;
        try {
            String s = ((ESTServerContext)PKIDMContext.getApplicationContext()).getPKIaaSUrl();
            URL url = new URL(s + "/se/ping/sr/" + srid);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            rc = conn.getResponseCode();
        }
        catch (Exception e) {
            this.logger.error("Ping to service failed", (Throwable)e);
        }
        return rc;
    }

    public abstract void handleRequest() throws IOException;
}

