/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.ctapi4ocf;

import de.cardcontact.opencard.terminal.ctapi4ocf.CTAPICardTerminal;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.VerifiedAPDUInterface;
import opencard.opt.util.TLV;
import opencard.opt.util.Tag;

public class CTAPIWithKeyboardCardTerminal
extends CTAPICardTerminal
implements VerifiedAPDUInterface {
    protected CTAPIWithKeyboardCardTerminal(String name, String type, String device, String libname) throws CardTerminalException {
        super(name, type, device, libname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU sendVerifiedCommandAPDU(SlotChannel chann, CommandAPDU capdu, CHVControl vc) throws CardTerminalException {
        int res;
        CommandAPDU command = new CommandAPDU(128);
        command.append((byte)32);
        command.append((byte)24);
        int slot = chann.getSlotNumber() + 1;
        command.append((byte)slot);
        command.append((byte)0);
        command.append((byte)0);
        byte[] tmp = new byte[capdu.getLength() + 2];
        if (vc.passwordEncoding().equals("String encoding")) {
            tmp[0] = (byte)(tmp[0] | 1);
        } else if (vc.passwordEncoding().equals("Format 2 Block")) {
            tmp[0] = (byte)(tmp[0] | 2);
        }
        tmp[1] = (byte)(vc.passwordOffset() + 6);
        System.arraycopy(capdu.getBuffer(), 0, tmp, 2, capdu.getLength());
        TLV ctpdo = new TLV(new Tag(18, 1, false), tmp);
        command.append(ctpdo.toBinary());
        String prompt = vc.prompt();
        if (prompt != null) {
            TLV dspdo = new TLV(new Tag(16, 1, false), prompt.getBytes());
            command.append(dspdo.toBinary());
        }
        command.setByte(4, command.getLength() - 5);
        byte[] buf = new byte[2];
        char buflen = (char)buf.length;
        CTAPIWithKeyboardCardTerminal cTAPIWithKeyboardCardTerminal = this;
        synchronized (cTAPIWithKeyboardCardTerminal) {
            res = this.CT.CT_Data(this.ctn, (byte)1, (byte)2, command.getBuffer(), buflen, buf);
        }
        if (res < 0) {
            throw new CardTerminalException("CTAPICardTerminal: PERFORM VERIFICATION failed, ERROR=" + res);
        }
        return new ResponseAPDU(buf);
    }
}

