/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2023 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview DFNPKIController
 */

var MenuModel = require('pki-as-a-service/ui/MenuModel').MenuModel;
var ServiceRequestModel	= require('pki-as-a-service/service/ServiceRequestModel').ServiceRequestModel;



function DFNPKIController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new DFNPKIController()");
}

exports.DFNPKIController = DFNPKIController;



DFNPKIController.prototype.getView = function(req, res, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	var homeURL = subjectController.ui.homeURL(req.url);

	div.appendChild( <h2>{subject.getName()}</h2> );
	div.appendChild( <p>Installation name: {subject.getCAName()}</p> );

	var certTable = subjectController.renderCertificate(subject, homeURL);
	if (certTable) {
		div.appendChild( <h2>CA Certificates</h2> );
		div.appendChild(certTable);
	}


	this.appendDFNPKIRolesView(div, subject);
	this.appendRAView(div, homeURL, subject);

	return div;
}



DFNPKIController.prototype.appendDFNPKIRolesView = function(div, subject) {
	var roles = subject.getDFNPKIRoles();
	if (roles.length > 0) {
		var rolesDiv = <div>
			<h2>DFN-PKI Roles</h2>
			<p>The following roles are supported by the CA:</p>
			<ul/>
		</div>;

		for (var i = 0; i < roles.length; i++) {
			var role = roles[i];

			rolesDiv.ul.li += <li>{ role }</li>;
		}

		div.appendChild(rolesDiv);
	}
}



DFNPKIController.prototype.appendRAView = function(div, homeURL, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	div.appendChild( <h2>Registration Authorities</h2> );
	div.appendChild( <p>The following Registration Authorities are configured for this CA:</p> );

	var holderList = subject.getCAHolderList();
	for (var i = 0; i < holderList.length; i++) {
		var holder = holderList[i];

		var raList = subject.getRegistrationAuthorityList(holder);
		for (var i = 0; i < raList.length; i++) {
			var ra = raList[i];

			var c = ra.getContent();
			var raDiv = <div />;
			raDiv.appendChild( <h3> RAID-{c.raID + " (" + c.description + ")"}</h3> );

			raDiv.appendChild(
				<a href={homeURL + "/role/" + c.raRoleId}>Show Registration Officer Role</a>
			);

			var dnPrefixes = <p>DN Prefixes:
				<ul/>
			</p>;

			for (var i = 0; i < c.dnPrefixes.length; i++) {
				var prefix = c.dnPrefixes[i];

				dnPrefixes.ul.li += <li>{ prefix }</li>;
			}

			if (c.dnPrefixes.length > 0) {
				raDiv.appendChild(dnPrefixes);
			}

			var domains = <p>Allowed Domains:
				<ul/>
			</p>;

			for (var i = 0; i < c.domains.length; i++) {
				var domain = c.domains[i];

				domains.ul.li += <li>{ domain.name }</li>;
			}

			if (c.domains.length > 0) {
				raDiv.appendChild(domains);
			}

			div.appendChild(raDiv);
		}
	}
}



// DFNPKIController.prototype.getMenuModel = function(req, subjectController, subject) {
// 	default xml namespace = "http://www.w3.org/1999/xhtml";
//
// 	var user = subjectController.ui.session.user;
//
// 	var homeURL = subjectController.ui.homeURL(req.url);
// 	var model = new MenuModel(<p class="no-margin">CA</p>);
//
// 	if (subject.isRegistrationOfficer(user)) {
// 		var process = "CreateDFNPKIRegistrationAuthorityServiceRequest";
// 		model.addItem(<a href={homeURL + "/sr/new?process=" + process + "&ca=" + subject.getId()}>Create DFN-PKI RA</a>);
// 	}
//
// 	if (model.hasChildren) {
// 		return model;
// 	}
// }
