/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2023 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Trust Center Subject
 */

var SubjectModel			= require('pki-as-a-service/service/SubjectModel').SubjectModel;



/**
 * Data model for X509 CA Subject
 *
 *
 * @constructor
 */
function DFNPKI(service, bo) {
	SubjectModel.call(this, service, bo);
}

DFNPKI.prototype = Object.create(SubjectModel.prototype);
DFNPKI.constructor = DFNPKI;

exports.DFNPKI = DFNPKI;



DFNPKI.prototype.getDFNPKIRoles = function() {
	var camodel = this.bo.getContent();
	return camodel.roles;
}



DFNPKI.prototype.getCAName = function() {
	var camodel = this.bo.getContent();
	return camodel.caName;
}



DFNPKI.prototype.getCAHolderList = function() {
	var holderDAO = this.service.daof.getHolderDAO();
	var holderList = holderDAO.getHolderListBySubject(this.getId());
	return holderList;
}



DFNPKI.prototype.getRegistrationAuthorityList = function(holder) {
	var signerDAO = this.service.daof.getSignerDAO();
	var raList = signerDAO.listSignerByHolderId(holder.id);
	return raList;
}



DFNPKI.prototype.isRegistrationOfficer = function(user) {
	var holderList = this.getCAHolderList();
	for (var i = 0; i < holderList.length; i++) {
		var holder = holderList[i];
		var raList = this.getRegistrationAuthorityList(holder);
		for (var i = 0; i < raList.length; i++) {
			var ra = raList[i];
			if (user.roles.indexOf(ra.getContent().raRoleId) >= 0) {
				GPSystem.log(GPSystem.DEBUG, module.id, "is registration officer of " + ra.name + " (" + ra.id + ")");
				return true;
			}
		}
	}

}



DFNPKI.prototype.canRead = function(user) {
	if (SubjectModel.prototype.canRead.call(this, user)) {
		return true;
	}

	if (this.isRegistrationOfficer(user)) {
		GPSystem.log(GPSystem.DEBUG, module.id, "canRead() : isRegistrationOfficer");
		return true;
	}
}
