/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2023 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request model for creating a DFN-PKI Registration Authority
 */

var ServiceRequestModel		= require('pki-as-a-service/service/ServiceRequestModel').ServiceRequestModel;



/**
 * Data model for requesting a certificate
 *
 *
 * @constructor
 */
function CreateDFNPKIRegistrationAuthorityRequestModel(service, bo) {
	ServiceRequestModel.call(this, service, bo);
}

CreateDFNPKIRegistrationAuthorityRequestModel.prototype = Object.create(ServiceRequestModel.prototype);
CreateDFNPKIRegistrationAuthorityRequestModel.constructor = CreateDFNPKIRegistrationAuthorityRequestModel;

exports.CreateDFNPKIRegistrationAuthorityRequestModel = CreateDFNPKIRegistrationAuthorityRequestModel;



CreateDFNPKIRegistrationAuthorityRequestModel.prototype.getForm = function(user) {
	if (this.form == undefined) {
		var editable = (user.id == this.getOriginatorId()) &&
			((this.bo.lifecycle == ServiceRequestModel.LIFECYCLE_NEW) ||
			(this.bo.lifecycle == ServiceRequestModel.LIFECYCLE_EDIT));


		this.form = [{
			id: "subjectData",
			legend: "msg.cdra.subjectData",
			fields: [
				{ id: "name", label: "msg.cdra.name", type: "text", size: 50, required: true, editable: editable, value: (this.model.name ? this.model.name : "") },
				{ id: "raId", label: "msg.cdra.raId", type: "number", min: 0, required: true, editable: editable, value: (this.model.raId ? this.model.raId : 0) },
				{ id: "description", label: "msg.cdra.description", type: "text", size: 50, required: true, editable: editable, value: (this.model.description ? this.model.description : "") },
			]},
		];

		if (this.getRecipientId()) {

		}
	}

	return this.form;
}



CreateDFNPKIRegistrationAuthorityRequestModel.prototype.getActionList = function(user) {
	if (this.actionList != undefined) {
		return this.actionList;
	}

	this.actionList = [];

	if (user.id == this.getOriginatorId()) {
		if ((this.bo.lifecycle == ServiceRequestModel.LIFECYCLE_NEW) ||
			(this.bo.lifecycle == ServiceRequestModel.LIFECYCLE_EDIT)) {
			this.actionList.push("action.save");
		}

		if (this.bo.lifecycle == ServiceRequestModel.LIFECYCLE_EDIT) {
			this.actionList.push("action.createra");
		}
	}

	return this.actionList;
}



CreateDFNPKIRegistrationAuthorityRequestModel.prototype.perform = function(user, action) {
	GPSystem.log(GPSystem.DEBUG, module.id, "perform(" + user.id + "," + action + ")");

	var actionList = this.getActionList(user);

	if (actionList.indexOf(action) == -1) {
		GPSystem.log(GPSystem.DEBUG, module.id, "action list :" + actionList);
		throw new GPError(module.id, GPError.INVALID_DATA, 0, "Action " + action + " unknown");
	}

	switch(action) {
		case "action.save":
			this.updateDetails(this.model.name + "-" + this.model.raId);
			this.setLifeCycle(ServiceRequestModel.LIFECYCLE_EDIT);
			this.setStatusInfo("Request data entered");
			break;
	}

	this.commit(user.id);
	return true;
}
