/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.subject;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.subject.Subject;
import org.openscdp.pkidm.subject.SubjectContent;
import org.openscdp.pkidm.subject.SubjectContentView;
import org.openscdp.pkidm.subject.SubjectFactoryBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubjectBase
implements Subject {
    final Logger logger = LoggerFactory.getLogger(SubjectFactoryBase.class);
    static final ObjectMapper om = new ObjectMapper();
    protected SubjectDTO dto;
    private JsonNode contentTree;

    protected SubjectBase(SubjectDTO dto) {
        this.dto = dto;
    }

    public Long getId() {
        return this.dto.getId();
    }

    public String getName() {
        return this.dto.getName();
    }

    public Long getManagedByRoleId() {
        return this.dto.getManagedByRoleId();
    }

    protected JsonNode getContentTree() {
        if (this.contentTree == null) {
            try {
                this.contentTree = om.readTree(this.dto.getContent());
            }
            catch (JsonProcessingException e) {
                this.logger.error("Failed to parse content field", (Throwable)e);
                throw new RuntimeException("Failed to parse content field", e);
            }
        }
        return this.contentTree;
    }

    protected <T extends SubjectContentView> T getContentView(Class<T> clazz) {
        try {
            JsonNode ct = this.getContentTree();
            return (T)((SubjectContentView)om.treeToValue((TreeNode)ct, clazz));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content field", (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    @Deprecated
    protected <T extends SubjectContent> T parseContent(Class<T> clazz) {
        try {
            return (T)((SubjectContent)om.readValue(this.dto.getContent(), clazz));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content field", (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    public void setContent(SubjectContent content) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            this.contentTree = om.valueToTree((Object)content);
            jsonstr = om.writeValueAsString((Object)this.contentTree);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }

    public void updateContent(SubjectContentView view) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            JsonNode update = om.valueToTree((Object)view);
            Iterator fields = update.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (this.contentTree.has((String)field.getKey())) {
                    ((ObjectNode)this.contentTree).replace((String)field.getKey(), (JsonNode)field.getValue());
                    continue;
                }
                if (((JsonNode)field.getValue()).isNull()) continue;
                ((ObjectNode)this.contentTree).set((String)field.getKey(), (JsonNode)field.getValue());
            }
            jsonstr = om.writeValueAsString((Object)this.contentTree);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }

    public abstract SubjectContentView getContent();

    public void commit() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        SubjectContentView cv = this.getContent();
        if (cv instanceof SubjectContent) {
            this.setContent((SubjectContent)cv);
        } else {
            this.updateContent(cv);
        }
        try (Handle handle = jdbi.open();){
            SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
            dao.update(this.dto);
        }
    }
}

