/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow.send;

import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMEntry;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.util.Arrays;
import java.util.LinkedList;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.escrow.send.SendKeyToEscrowSharedServiceRequest;
import org.openscdp.pkidb.dao.KeyEscrowDAO;
import org.openscdp.pkidb.dto.KeyEscrowDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.cvc.CVCSigner;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumerateKeysAction
extends ServiceRequestSmartCardHSMAction {
    public static final String ACTION = "action.kess.enumeratekeys";
    private final Logger logger = LoggerFactory.getLogger(EnumerateKeysAction.class);
    private SendKeyToEscrowSharedServiceRequest serviceRequest;

    public EnumerateKeysAction(SendKeyToEscrowSharedServiceRequest serviceRequest) {
        super(ACTION, (ServiceRequest)serviceRequest);
        this.serviceRequest = serviceRequest;
        String lastSeenAt = serviceRequest.getBackendConnectedTo();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    @Override
    public JSONActionResult execute() {
        String lastSeenAt = this.serviceRequest.getBackendConnectedTo();
        if (lastSeenAt == null) {
            return this.getStatus();
        }
        return this.execute(this.serviceRequest.getContent().getTokenPath());
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        try {
            SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
            if (!service.getId().equals(this.serviceRequest.getContent().getTokenPath())) {
                throw new ServiceRequestActionException("Wrong Token presented");
            }
            CVCSigner escrowSigner = this.serviceRequest.getKeyEscrowHolder().getSigner();
            LinkedList<String> result = new LinkedList<String>();
            LinkedList<String> escrowedAliases = new LinkedList<String>();
            for (String alias : service.getAliases()) {
                SmartCardHSMEntry entry = service.getSmartCardHSMEntry(alias);
                SmartCardHSMKey key = entry.getKey();
                if (key == null) {
                    this.logger.debug("Key " + alias + " not found");
                    continue;
                }
                KeyDomain kd = key.getKeyDomain();
                if (kd == null) {
                    this.logger.debug("Key " + alias + " is not member of the key domain");
                    continue;
                }
                if (!Arrays.equals(escrowSigner.getKeyDomain(), key.getKeyDomain().getKeyDomainUID())) {
                    this.logger.debug("Key " + alias + " is member of another key domain");
                    continue;
                }
                if (key.hasKeyUseCounter()) {
                    this.logger.debug("Key " + alias + " has a use counter");
                    continue;
                }
                byte[] algorithmList = key.getAlgorithms();
                if (algorithmList != null) {
                    int i;
                    for (i = 0; i < algorithmList.length && (algorithmList[i] & 0xFF) != 146; ++i) {
                    }
                    if (i >= algorithmList.length) {
                        this.logger.debug("WRAP Key is not in the algorithm list for key " + alias);
                        continue;
                    }
                }
                Handle handle = PKIDMContext.getJDBI().open();
                try {
                    KeyEscrowDAO dao = (KeyEscrowDAO)handle.attach(KeyEscrowDAO.class);
                    KeyEscrowDTO dto = dao.getKeyEscrowBySignerAndKeyId(escrowSigner.getId(), key.getKeyId());
                    if (dto != null) {
                        this.logger.debug("Key " + dto.getName() + " already in escrow");
                        escrowedAliases.add(alias);
                        continue;
                    }
                    result.add(alias);
                }
                finally {
                    if (handle == null) continue;
                    handle.close();
                }
            }
            this.serviceRequest.getContent().aliases = result;
            this.serviceRequest.getContent().escrowedAliases = escrowedAliases;
            this.serviceRequest.setStatusInfo("Keys enumerated");
        }
        catch (ServiceRequestActionException srae) {
            throw srae;
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

