/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.utils;

import de.dfncert.errors.ClientException;
import de.dfncert.errors.ConfigurationException;
import de.dfncert.errors.ProgrammingError;
import de.dfncert.utils.UtilsIO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UtilsXML {
    private static DocumentBuilderFactory docBuilderFactory;

    private UtilsXML() {
    }

    public static DocumentBuilderFactory getDocBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return docBuilderFactory;
    }

    public static Element getNextElementSibling(Node node) {
        if (node == null) {
            return null;
        }
        Node next = node.getNextSibling();
        if (next == null) {
            return null;
        }
        while (next != null && next.getNodeType() != 1) {
            next = next.getNextSibling();
        }
        return (Element)next;
    }

    public static String getFirstChildValue(Node element) {
        String value;
        try {
            value = UtilsXML.getFirstChildValue(element, false);
        }
        catch (Exception ex) {
            value = null;
        }
        return value;
    }

    public static String getFirstChildValue(Node element, boolean checkPrivKey) throws ClientException {
        if (element == null) {
            return null;
        }
        Node child = element.getFirstChild();
        if (child == null) {
            return null;
        }
        String value = child.getNodeValue();
        if (value != null && !value.isEmpty() && value.contains("PRIVATE KEY-----")) {
            throw new ClientException("Private Key detected");
        }
        return value;
    }

    public static Node getFirstElementChild(Node element) {
        if (element == null) {
            return null;
        }
        Node child = element.getFirstChild();
        if (child == null || child.getNodeType() == 1) {
            return child;
        }
        return UtilsXML.getNextElementSibling(child);
    }

    public static String getFirstElementValue(Document doc, String elname, String deflt) {
        NodeList nodes = doc.getElementsByTagName(elname);
        if (nodes.getLength() > 0) {
            return UtilsXML.getFirstChildValue(nodes.item(0));
        }
        return deflt;
    }

    public static boolean getBoolean(Document doc, String elname, boolean deflt) {
        String value = UtilsXML.getFirstElementValue(doc, elname, deflt ? "1" : "0");
        if (value == null) {
            return deflt;
        }
        return value.equals("1");
    }

    public static String[] getRPCArray(Node node) throws ClientException {
        ArrayList<String> result = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            result.add(UtilsXML.getFirstChildValue(child, true));
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean hasAttributeWithLocalName(Node node, String local) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return false;
        }
        int len = map.getLength();
        for (int i = 0; i < len; ++i) {
            Node attr = node.getAttributes().item(i);
            if (!attr.getNodeName().endsWith(local)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttributeWithArray(Node node) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return false;
        }
        for (int i = 0; i < map.getLength(); ++i) {
            if (!map.item(i).getTextContent().contains("ArrayOf")) continue;
            return true;
        }
        return false;
    }

    public static String getConnectionString(File caDir) throws ConfigurationException {
        Document doc;
        DocumentBuilder docbuilder;
        String ca = caDir.getName();
        try {
            docbuilder = UtilsXML.getDocBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new ProgrammingError("Probleme mit dem XML-Parser", ex);
        }
        File dbFile = new File(caDir, "/config/database.xml");
        UtilsIO.checkExistsAndReadable(dbFile);
        try {
            doc = docbuilder.parse(dbFile);
        }
        catch (SAXException ex) {
            throw new ConfigurationException("Konnte Datenbankkonfiguration f\u00fcr " + ca + " nicht parsen.", ex, dbFile);
        }
        catch (IOException ex) {
            throw new ConfigurationException("Konnte Datenbankkonfiguration f\u00fcr " + ca + " nicht parsen.", ex, dbFile);
        }
        return String.format("jdbc:postgresql://%s/%s?user=%s&password=%s", UtilsXML.getFirstElementValue(doc, "host", null), UtilsXML.getFirstElementValue(doc, "name", null), UtilsXML.getFirstElementValue(doc, "user", null), UtilsXML.getFirstElementValue(doc, "passwd", null));
    }

    public static ArrayList<String> getValuesByTagName(Document doc, String tagName) {
        ArrayList<String> valueList = new ArrayList<String>();
        NodeList nodes = doc.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node adpNode = nodes.item(i);
            Node adpValueNode = adpNode.getFirstChild();
            if (adpValueNode == null) continue;
            valueList.add(adpValueNode.getNodeValue());
        }
        return valueList;
    }

    public static ArrayList<Integer> getIntValuesByTagName(Document doc, String tagName) {
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        NodeList nodes = doc.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node adpNode = nodes.item(i);
            Node adpValueNode = adpNode.getFirstChild();
            if (adpValueNode == null) continue;
            valueList.add(Integer.decode(adpValueNode.getNodeValue()));
        }
        return valueList;
    }
}

