/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.enums;

public enum RevocationReason {
    UNSPECIFIED(0, "Ohne Angabe", "Unspecified"),
    KEY_COMPROMISE(1, "Schl\u00fcssel kompromittiert", "Key Compromise"),
    CA_COMPROMISE(2, "CA-Schl\u00fcssel kompromittiert", "CA Key Compromise"),
    AFFILIATION_CHANGED(3, "\u00c4nderung der Zugeh\u00f6rigkeit", "Change of Affiliation"),
    SUPERSEDED(4, "Ersetzt", "Superseded"),
    CESSATION_OF_OPERATION(5, "Nicht mehr im Einsatz", "Cessation of Operation");

    private final int reasonCode;
    private final String labelDE;
    private final String labelEN;

    private RevocationReason(int reasonCode, String labelDE, String labelEN) {
        this.reasonCode = reasonCode;
        this.labelDE = labelDE;
        this.labelEN = labelEN;
    }

    public static RevocationReason getByCode(int reasonCode) {
        for (RevocationReason reason : RevocationReason.values()) {
            if (reason.reasonCode != reasonCode) continue;
            return reason;
        }
        throw new IllegalArgumentException("Es existiert kein RevocationReason mit Code " + reasonCode);
    }

    public static RevocationReason[] getEndEntityReasons() {
        return new RevocationReason[]{AFFILIATION_CHANGED, SUPERSEDED, CESSATION_OF_OPERATION, KEY_COMPROMISE};
    }

    public static RevocationReason[] getCAReasons() {
        return new RevocationReason[]{CA_COMPROMISE, AFFILIATION_CHANGED, SUPERSEDED, CESSATION_OF_OPERATION};
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public String getLabelDE() {
        return this.labelDE;
    }

    public String getLabelEN() {
        return this.labelEN;
    }

    public String toString() {
        return this.getLabelDE();
    }
}

