/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.tools;

import de.dfncert.tools.Cryptography;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import java.util.Vector;

public class DFNPKIUtils {
    private DFNPKIUtils() {
    }

    public static String escapeDN(String dn) {
        if (dn == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(dn.length() * 2);
        StringTokenizer tokenizer = new StringTokenizer(dn, ",");
        boolean first = true;
        while (tokenizer.hasMoreElements()) {
            String next = tokenizer.nextToken();
            if (!next.contains("=")) {
                result.append("\\,");
                result.append(next);
            } else {
                if (!first) {
                    result.append(",");
                }
                result.append(next);
            }
            first = false;
        }
        return result.toString();
    }

    public static String getCertificateWithChainPEM(String[] cacerts, String cert) throws Exception {
        Vector<X509Certificate> complete = DFNPKIUtils.getCertificateWithChain(cacerts, cert);
        StringBuilder buffer = new StringBuilder();
        for (X509Certificate current : complete) {
            String dn = current.getSubjectX500Principal().toString();
            buffer.append("subject=/");
            buffer.append(dn.replaceAll(", ", "/"));
            buffer.append("\n");
            buffer.append(Cryptography.getPEMFromCertificate(current));
        }
        return buffer.toString();
    }

    public static Vector<X509Certificate> getCertificateWithChain(String[] cacerts, String cert) throws Exception {
        Vector<X509Certificate> certs = new Vector<X509Certificate>();
        Vector<X509Certificate> result = new Vector<X509Certificate>();
        String[] stringArray = cacerts;
        int n = cacerts.length;
        int n2 = 0;
        while (n2 < n) {
            String current = stringArray[n2];
            certs.add(Cryptography.getCertificateFromPEM(current));
            ++n2;
        }
        X509Certificate certObject = Cryptography.getCertificateFromPEM(cert);
        result.add(certObject);
        while (certObject != null) {
            boolean found = false;
            for (X509Certificate current : certs) {
                if (!current.getSubjectDN().equals(certObject.getIssuerDN())) continue;
                result.add(current);
                certObject = current;
                found = true;
                break;
            }
            if (!found) {
                throw new Exception("Issuer for " + certObject.getSubjectDN().toString() + " not found");
            }
            if (!certObject.getSubjectDN().equals(certObject.getIssuerDN())) continue;
            certObject = null;
        }
        return result;
    }
}

