/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.slight;

import de.dfncert.enums.EmailLocation;
import de.dfncert.enums.EmailState;
import de.dfncert.utils.UtilsFormat;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class RPCSerializer {
    private DocumentBuilder builder;
    private Document requestDoc;
    private String targetNamespace;

    public RPCSerializer(String targetNamespace) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        this.builder = factory.newDocumentBuilder();
        this.targetNamespace = targetNamespace;
    }

    public Document getRequestDocument(String methodName, String[] paramNames, Object[] paramValues) throws IllegalAccessException {
        this.requestDoc = this.builder.newDocument();
        this.requestDoc.setXmlVersion("1.0");
        Element envelope = this.requestDoc.createElement("SOAP-ENV:Envelope");
        envelope.setAttribute("SOAP-ENV:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
        envelope.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        envelope.setAttribute("xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        envelope.setAttribute("xmlns:SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        envelope.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Element body = this.requestDoc.createElement("SOAP-ENV:Body");
        Element method = this.requestDoc.createElement("ns1:" + methodName);
        method.setAttribute("xmlns:ns1", this.targetNamespace);
        int i = 0;
        while (i < paramNames.length) {
            Element parameter = this.serializeObject(paramValues[i], paramNames[i]);
            method.appendChild(parameter);
            ++i;
        }
        body.appendChild(method);
        envelope.appendChild(body);
        this.requestDoc.appendChild(envelope);
        return this.requestDoc;
    }

    private String getXsiType(Class objectClass) {
        if (objectClass == String.class) {
            return "xsd:string";
        }
        if (objectClass == Integer.class) {
            return "xsd:int";
        }
        if (objectClass == BigInteger.class) {
            return "xsd:integer";
        }
        if (objectClass == Boolean.class) {
            return "xsd:boolean";
        }
        if (objectClass == Long.class) {
            return "xsd:long";
        }
        if (objectClass == Date.class) {
            return "xsd:dateTime";
        }
        if (objectClass == byte[].class) {
            return "xsd:base64Binary";
        }
        if (objectClass == String[].class) {
            return "xsd:string[]";
        }
        if (objectClass == Integer[].class) {
            return "xsd:int[]";
        }
        if (objectClass == Long[].class) {
            return "xsd:long[]";
        }
        if (objectClass == Boolean[].class) {
            return "xsd:boolean[]";
        }
        return "ns1:" + objectClass.getSimpleName().replaceAll(".*\\.", "");
    }

    public Element serializeObject(Object in, String elementName) throws IllegalAccessException {
        Element currentElement = this.requestDoc.createElement(elementName);
        if (in == null) {
            currentElement.setAttribute("xsi:null", "1");
            return currentElement;
        }
        Class<?> objectClass = in.getClass();
        if (objectClass == Integer.class || objectClass == BigInteger.class || objectClass == Boolean.class || objectClass == String.class || objectClass == Long.class || objectClass == Float.class || objectClass == Double.class) {
            Text value = this.requestDoc.createTextNode(in.toString());
            currentElement.setAttribute("xsi:type", this.getXsiType(objectClass));
            currentElement.appendChild(value);
        } else if (objectClass == Date.class) {
            Text value = this.requestDoc.createTextNode(UtilsFormat.dateToIsoDate((Date)((Date)in)));
            currentElement.setAttribute("xsi:type", "xsd:dateTime");
            currentElement.appendChild(value);
        } else if (objectClass == byte[].class) {
            Text value = this.requestDoc.createTextNode(Base64.getMimeEncoder().encodeToString((byte[])in));
            currentElement.setAttribute("xsi:type", "xsd:base64Binary");
            currentElement.appendChild(value);
        } else if (objectClass == EmailState.class) {
            EmailState state = (EmailState)in;
            Text value = this.requestDoc.createTextNode(state.name());
            currentElement.setAttribute("xsi:type", "EMailState");
            currentElement.appendChild(value);
        } else if (objectClass == EmailLocation.class) {
            EmailLocation location = (EmailLocation)in;
            Text value = this.requestDoc.createTextNode(location.name());
            currentElement.setAttribute("xsi:type", "EMailLocation");
            currentElement.appendChild(value);
        } else if (objectClass.isArray()) {
            currentElement.setAttribute("xsi:type", "SOAP-ENC:Array");
            currentElement.setAttribute("SOAP-ENC:arrayType", this.getXsiType(objectClass).replaceFirst("\\[\\]", "[" + Array.getLength(in) + "]"));
            int i = 0;
            while (i < Array.getLength(in)) {
                currentElement.appendChild(this.serializeObject(Array.get(in, i), "item"));
                ++i;
            }
        } else {
            currentElement.setAttribute("xsi:type", "ns1:" + objectClass.getSimpleName());
            List<Field> fields = RPCSerializer.getAllFields(objectClass);
            for (Field field : fields) {
                if (Modifier.isTransient(field.getModifiers())) continue;
                field.setAccessible(true);
                Object current = field.get(in);
                currentElement.appendChild(this.serializeObject(current, field.getName()));
            }
        }
        return currentElement;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> c = clazz;
        while (c != null) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
            c = c.getSuperclass();
        }
        return fields;
    }
}

