/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.servicerequest;

import com.fasterxml.jackson.databind.JsonNode;
import de.dfncert.tools.Cryptography;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.dfn.connector.pkidm.action.DFNApproveAction;
import org.openscdp.dfn.connector.pkidm.action.DFNCertReqAction;
import org.openscdp.dfn.connector.pkidm.action.DFNCertRetrievalAction;
import org.openscdp.dfn.connector.pkidm.action.DFNRevocationRequestAction;
import org.openscdp.dfn.connector.pkidm.action.DFNRevokeAction;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequest;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequestContent;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthority;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.RequestDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.RequestDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFNCertificateRequestBase
extends ServiceRequestBase
implements DFNCertificateRequest {
    final Logger logger = LoggerFactory.getLogger(DFNCertificateRequestBase.class);
    public static final String PROCESS = "DFNCertificateServiceRequest";
    protected DFNCertificateRequestContent content;

    public DFNCertificateRequestBase(ServiceRequestDTO dto) {
        super(dto);
    }

    @Override
    public DFNCertificateRequestContent getContent() {
        if (this.content == null) {
            this.content = (DFNCertificateRequestContent)this.getContentView(DFNCertificateRequestContent.class);
        }
        return this.content;
    }

    @Override
    public int getCertificateRequestSerialNumber() {
        return this.getContent().serial;
    }

    @Override
    public void setCertificateRequestSerialNumber(int serial) {
        this.getContent().serial = serial;
    }

    @Override
    public Integer getRevocationRequestSerialNumber() {
        return this.getContent().revocationSerial;
    }

    @Override
    public void setRevocationRequestSerialNumber(int serial) {
        this.getContent().revocationSerial = serial;
    }

    @Override
    public String getPIN() {
        String pw = this.getContent().pin;
        try {
            String pin = Cryptography.sha1((byte[])pw.getBytes());
            return pin;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("PIN derivation failed", e);
        }
    }

    @Override
    public Integer getRevocationReason() {
        return this.getContent().revocationReason;
    }

    @Override
    public void setRevocationReason(int reason) {
        this.getContent().revocationReason = DFNCertificateRequestBase.toOCSPReasonCode(reason);
    }

    @Override
    public String[] getSubjectAltNames() {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        for (String email : this.getContent().subjectAlternativeNameEmail) {
            l.add((CallSite)((Object)("email:" + email)));
        }
        for (String dns : this.getContent().subjectAlternativeNameDNS) {
            l.add((CallSite)((Object)("DNS:" + dns)));
        }
        for (String ip : this.getContent().subjectAlternativeNameIP) {
            l.add((CallSite)((Object)("IP:" + ip)));
        }
        for (String uri : this.getContent().subjectAlternativeNameURI) {
            l.add((CallSite)((Object)("URI:" + uri)));
        }
        for (String mupn : this.getContent().subjectAlternativeNameMicrosoftUPN) {
            l.add((CallSite)((Object)("Microsoft_UPN:" + mupn)));
        }
        return l.toArray(new String[l.size()]);
    }

    @Override
    public String getRole() {
        return this.getContent().role;
    }

    @Override
    public String getName() {
        return this.getContent().name;
    }

    @Override
    public String getEmail() {
        return this.getContent().email;
    }

    @Override
    public String getOrgUnit() {
        return this.getContent().orgUnit;
    }

    @Override
    public boolean isPublish() {
        return this.getContent().publish;
    }

    @Override
    public String getSubjectDN() {
        return this.getContent().subjectDN;
    }

    public RequestDTO getRequest() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            RequestDTO req;
            RequestDAO requestDAO = (RequestDAO)handle.attach(RequestDAO.class);
            RequestDTO requestDTO = req = requestDAO.getRequest(this.getContent().requestId);
            return requestDTO;
        }
    }

    @Override
    public BigInteger getCertificateSerialNumber() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            BigInteger serial;
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            List certs = certDAO.getCertificateByServiceRequestId(this.getId());
            if (certs.size() == 0) {
                throw new RuntimeException("No certificate found");
            }
            if (certs.size() > 1) {
                throw new RuntimeException("Too many certificates found");
            }
            CertificateDTO cert = (CertificateDTO)certs.get(0);
            BigInteger bigInteger = serial = new BigInteger(cert.getSerial());
            return bigInteger;
        }
    }

    public static int getRevocationReason(JSONAction action) {
        JsonNode fields = action.args.get("fields");
        if (fields.has("revocationReason")) {
            String reason = fields.get("revocationReason").asText();
            Integer reasonInt = Integer.valueOf(reason);
            switch (reasonInt) {
                case 100: 
                case 101: 
                case 103: 
                case 104: 
                case 105: {
                    return reasonInt - 100;
                }
            }
            throw new RuntimeException("Unsupported revocation reason: " + reason);
        }
        throw new RuntimeException("No revocation reason given");
    }

    public static int toOCSPReasonCode(int reason) {
        switch (reason) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return reason + 100;
            }
        }
        throw new RuntimeException("Unsupported revocation reason: " + reason);
    }

    @Override
    public RegistrationAuthority getRA() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            RegistrationAuthority ra;
            SignerDAO signerDAO = (SignerDAO)handle.attach(SignerDAO.class);
            Long signerId = this.getContent().signerId;
            SignerDTO signerDTO = signerDAO.getSigner(signerId);
            RegistrationAuthority registrationAuthority = ra = new RegistrationAuthority(signerDTO);
            return registrationAuthority;
        }
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        if (action.action.equals("action.dfncr.forward")) {
            return new DFNCertReqAction(this, action.user);
        }
        if (action.action.equals("action.dfncr.retrieve")) {
            return new DFNCertRetrievalAction(this, action.user);
        }
        if (action.action.equals("action.approve")) {
            return new DFNApproveAction(this, action.user);
        }
        if (action.action.equals("action.cr.revoke")) {
            return new DFNRevokeAction(this, action);
        }
        if (action.action.equals("action.cr.requestRevocation")) {
            return new DFNRevocationRequestAction(this, action);
        }
        return null;
    }
}

