/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.action;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.openscdp.dfn.connector.pkidm.action.DFNRegistrationAuthorityAction;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequestBase;

public abstract class DFNSignatureAction
extends DFNRegistrationAuthorityAction {
    public DFNSignatureAction(DFNCertificateRequestBase serviceRequest) {
        super(serviceRequest, serviceRequest.getRA().getCAName());
    }

    protected String signRequest(SmartCardHSMProvider provider, byte[] rawRequest) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, CertStoreException, InvalidAlgorithmParameterException, OperatorCreationException, CMSException {
        KeyStore ks = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)provider);
        ks.load(null, null);
        String alias = this.findRAAlias(ks);
        PrivateKey key = (PrivateKey)ks.getKey(alias, null);
        X509Certificate raCert = (X509Certificate)ks.getCertificate(alias);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder("SHA256WithRSAEncryption");
        ContentSigner signer = builder.setProvider((Provider)provider).build(key);
        DigestCalculatorProvider digestProvider = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
        JcaSignerInfoGeneratorBuilder signerInfoBuilder = new JcaSignerInfoGeneratorBuilder(digestProvider);
        SignerInfoGenerator signerInfoGen = signerInfoBuilder.build(signer, (X509CertificateHolder)new JcaX509CertificateHolder(raCert));
        gen.addSignerInfoGenerator(signerInfoGen);
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(1);
        list.add(raCert);
        JcaCertStore jcaCertStore = new JcaCertStore(list);
        gen.addCertificates((Store)jcaCertStore);
        CMSSignedData data = gen.generate((CMSTypedData)new CMSProcessableByteArray(rawRequest), false);
        String signedRequest = DFNSignatureAction.toPKCS7PEM(data.getEncoded());
        return signedRequest;
    }

    private static String toPKCS7PEM(byte[] data) {
        String dataBase64 = new String(Base64.encode((byte[])data));
        StringBuilder pkcs7 = new StringBuilder();
        pkcs7.append("-----BEGIN PKCS7-----\n");
        for (int i = 0; i < dataBase64.length(); i += 64) {
            if (i + 64 >= dataBase64.length()) {
                pkcs7.append(dataBase64.substring(i));
            } else {
                pkcs7.append(dataBase64.substring(i, i + 64));
            }
            pkcs7.append("\n");
        }
        pkcs7.append("-----END PKCS7-----\n");
        return pkcs7.toString();
    }
}

