/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.action;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.dfncert.enums.RevocationReason;
import java.math.BigInteger;
import org.openscdp.dfn.connector.pkidm.Utils;
import org.openscdp.dfn.connector.pkidm.action.DFNSignatureAction;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequestBase;
import org.openscdp.pkidm.json.JSONAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFNRevokeAction
extends DFNSignatureAction {
    final Logger logger = LoggerFactory.getLogger(DFNRevokeAction.class);
    protected DFNCertificateRequestBase sr;
    private JSONAction action;

    public DFNRevokeAction(DFNCertificateRequestBase serviceRequest, JSONAction action) {
        super(serviceRequest);
        this.sr = serviceRequest;
        this.action = action;
    }

    public void execute(SmartCardHSMProvider provider) {
        try {
            this.authenticate(provider);
            if (this.sr.getRevocationRequestSerialNumber() == null) {
                this.requestRevocationByRA(provider);
            }
            this.revokeRequest(provider);
        }
        catch (Exception e) {
            throw new RuntimeException("DFNRevokeAction failed (SR-ID: " + this.sr.getId() + ")", e);
        }
    }

    public void requestRevocationByRA(SmartCardHSMProvider provider) throws Exception {
        int reasonCode = DFNCertificateRequestBase.getRevocationReason(this.action);
        RevocationReason reason = RevocationReason.getByCode((int)reasonCode);
        BigInteger serial = this.sr.getCertificateSerialNumber();
        int revocationSerial = this.client.getRegistration().newRevocationRequest(serial, reason);
        this.sr.setRevocationRequestSerialNumber(revocationSerial);
        this.sr.setRevocationReason(reasonCode);
        this.sr.setStatusInfo("New revocation request by RA");
        this.sr.setLifeCycle(12);
        this.sr.commit(this.action.user, null);
    }

    public void revokeRequest(SmartCardHSMProvider provider) throws Exception {
        int revocationSerial = this.sr.getRevocationRequestSerialNumber();
        byte[] raw = this.client.getRegistration().getRawRevocationRequest(revocationSerial);
        String signedRequest = this.signRequest(provider, raw);
        boolean approved = this.client.getRegistration().approveRevocationRequest(revocationSerial, raw, signedRequest);
        if (approved) {
            Utils.setCertificateRevocationStatus(this.sr.getId(), this.sr.getRevocationReason());
            this.sr.setRoleId(null);
            this.sr.setStatusInfo("Certificate revoked by RA");
            this.sr.setLifeCycle(13);
        } else {
            this.sr.setStatusInfo("Certificate revocation by RA failed");
        }
        this.sr.commit(this.action.user, null);
    }
}

