/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.action;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.dfncert.tools.DFNPKIClient;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DFNRegistrationAuthorityAction
extends ServiceRequestSmartCardHSMAction {
    final Logger logger = LoggerFactory.getLogger(DFNRegistrationAuthorityAction.class);
    protected DFNPKIClient client;

    public DFNRegistrationAuthorityAction(ServiceRequest serviceRequest, String caName) {
        super(serviceRequest);
        try {
            this.client = new DFNPKIClient(caName);
        }
        catch (Exception e) {
            throw new ProviderException("DFNPKIClient setup failed", e);
        }
    }

    protected void authenticate(SmartCardHSMProvider provider) {
        try {
            KeyStore ksKeys = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)provider);
            ksKeys.load(null, null);
            String alias = this.findRAAlias(ksKeys);
            this.client.loadRAFromKeystore(ksKeys, alias, null);
        }
        catch (Exception e) {
            throw new ProviderException(e.getMessage(), e);
        }
    }

    protected String findRAAlias(KeyStore ks) throws KeyStoreException {
        String raAlias = null;
        Enumeration<String> aliases = ks.aliases();
        LinkedList<String> candidates = new LinkedList<String>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            if (alias.contains("RAID")) {
                raAlias = alias;
            }
            candidates.add(alias);
        }
        if (raAlias == null) {
            if (candidates.isEmpty()) {
                throw new NoSuchElementException("No RA certificate found on token for authentication");
            }
            raAlias = (String)candidates.getFirst();
        }
        this.logger.debug("Potential RA aliases are " + String.valueOf(candidates));
        this.logger.debug("Select alias " + raAlias);
        return raAlias;
    }
}

