/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.dfn.connector.pkidm.servicerequest.SAPCertificateServiceRequest;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFNConnectorServlet
extends HttpServlet {
    final Logger logger = LoggerFactory.getLogger(DFNConnectorServlet.class);
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APPLICATION_PDF = "application/pdf";

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.logger.info("doPost");
        ServletInputStream is = req.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is));
        String srId = r.readLine();
        this.logger.info(srId);
        Long id = Long.valueOf(srId);
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            ServiceRequestDTO dto = dao.getServiceRequest(id);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.logger.info("doGet " + req.getPathInfo());
        try {
            ServiceRequestDTO dto;
            Jdbi jdbi = PKIDMContext.getJDBI();
            long id = 318L;
            try (Handle handle = jdbi.open();){
                ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
                dto = dao.getServiceRequest(Long.valueOf(id));
            }
            SAPCertificateServiceRequest sapReq = new SAPCertificateServiceRequest(dto);
            String pi = req.getPathInfo();
            if (pi != null && pi.equals("/authenticate")) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

