/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.argument.QualifiedArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.enums.DatabaseValue;
import org.jdbi.v3.core.enums.EnumStrategy;
import org.jdbi.v3.core.internal.EnumStrategies;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.qualifier.QualifiedType;

class EnumArgumentFactory
implements QualifiedArgumentFactory {
    EnumArgumentFactory() {
    }

    @Override
    public Optional<Argument> build(QualifiedType<?> givenType, Object value, ConfigRegistry config) {
        return EnumArgumentFactory.ifEnum(givenType.getType()).flatMap(clazz -> EnumArgumentFactory.makeEnumArgument(givenType, (Enum)value, config));
    }

    static <E extends Enum<E>> Optional<Class<E>> ifEnum(Type type) {
        Class cast;
        if (type instanceof Class && Enum.class.isAssignableFrom(cast = (Class)type)) {
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    private static <E extends Enum<E>> Optional<Argument> makeEnumArgument(QualifiedType<E> givenType, E value, ConfigRegistry config) {
        boolean byName = EnumStrategy.BY_NAME == config.get(EnumStrategies.class).findStrategy(givenType);
        return byName ? EnumArgumentFactory.byName(value, config) : EnumArgumentFactory.byOrdinal(value, config);
    }

    private static <E extends Enum<E>> Optional<Argument> byName(E value, ConfigRegistry config) {
        return EnumArgumentFactory.makeArgument(12, String.class, value, EnumArgumentFactory::annotatedValue, config);
    }

    private static <E extends Enum<E>> String annotatedValue(E e) {
        return Optional.of(e.getDeclaringClass()).map(Unchecked.function(type -> type.getField(e.name()))).map(field -> field.getAnnotation(DatabaseValue.class)).map(DatabaseValue::value).orElse(e.name());
    }

    private static <E extends Enum<E>> Optional<Argument> byOrdinal(E value, ConfigRegistry config) {
        return EnumArgumentFactory.makeArgument(4, Integer.class, value, Enum::ordinal, config);
    }

    private static <A, E extends Enum<E>> Optional<Argument> makeArgument(int nullType, Class<A> attributeType, E value, Function<E, A> transform, ConfigRegistry config) {
        if (value == null) {
            return Optional.of(new NullArgument(nullType));
        }
        return config.get(Arguments.class).findFor(attributeType, transform.apply(value));
    }
}

