/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import de.cardcontact.tlv.TreeNode;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.SimpleTimeZone;

public class PrimitiveTLV
extends TLV {
    protected byte[] value = null;

    public PrimitiveTLV(Tag newtag, byte[] newvalue) {
        this.tag = newtag;
        this.value = newvalue;
    }

    public PrimitiveTLV(int newTagValue, byte[] newvalue) throws TLVEncodingException {
        this.tag = new Tag(newTagValue);
        this.value = newvalue;
    }

    public PrimitiveTLV(byte[] buffer, int offset) throws TLVEncodingException {
        this.tag = new Tag(buffer, offset);
        int length = PrimitiveTLV.lengthFromByteArray(buffer, offset += this.tag.getSize(), this.alternateLengthFormat);
        this.value = new byte[length];
        System.arraycopy(buffer, offset += PrimitiveTLV.getLengthFieldSizeHelper(length, this.alternateLengthFormat), this.value, 0, length);
    }

    public PrimitiveTLV(byte[] buffer) throws TLVEncodingException {
        this(buffer, 0);
    }

    public PrimitiveTLV(ParseBuffer pb) throws TLVEncodingException {
        this.tag = new Tag(pb);
        int length = this.alternateLengthFormat ? pb.getDGILength() : pb.getDERLength();
        if (length < 0) {
            throw new TLVEncodingException("Variable length encoding not possible for primitive TLV");
        }
        if (length > pb.remaining()) {
            throw new TLVEncodingException("Length field (" + length + ") exceeds value field (" + pb.remaining() + ").");
        }
        this.value = new byte[length];
        pb.get(this.value, 0, length);
    }

    public PrimitiveTLV(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!(tlv instanceof PrimitiveTLV)) {
            throw new UnsupportedOperationException("Can not clone from other than primitive TLV");
        }
        this.value = ((PrimitiveTLV)tlv).value;
    }

    @Override
    protected int valueToByteArray(byte[] buffer, int offset) {
        if (this.value != null) {
            System.arraycopy(this.value, 0, buffer, offset, this.value.length);
            offset += this.value.length;
        }
        return offset;
    }

    @Override
    protected int toByteArray(byte[] buffer, int offset) {
        int length = this.value == null ? 0 : this.value.length;
        offset = this.tag.toByteArray(buffer, offset);
        offset = PrimitiveTLV.lengthToByteArray(length, buffer, offset, this.alternateLengthFormat);
        if (this.value != null) {
            System.arraycopy(this.value, 0, buffer, offset, this.value.length);
            offset += this.value.length;
        }
        return offset;
    }

    @Override
    public int getLength() {
        return this.value == null ? 0 : this.value.length;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    public Date getDate() throws UnsupportedEncodingException {
        ParsePosition pp;
        Date date = null;
        boolean utc = false;
        String str = new String(this.value, "8859_1");
        Object format = str.length() == 11 ? "yyMMddHHmm" : (str.length() == 13 ? "yyMMddHHmmss" : "yyyyMMddHHmmss");
        if (str.length() > 14 && (str.charAt(14) == '.' || str.charAt(14) == ',')) {
            format = (String)format + ".SSS";
        }
        if (str.endsWith("Z")) {
            utc = true;
        } else if (str.charAt(str.length() - 5) == '-' || str.charAt(str.length() - 5) == '+') {
            format = (String)format + "Z";
        }
        SimpleDateFormat formatter = new SimpleDateFormat((String)format);
        if (utc) {
            formatter.setTimeZone(new SimpleTimeZone(0, "Z"));
        }
        if ((date = formatter.parse(str, pp = new ParsePosition(0))) == null) {
            throw new UnsupportedEncodingException("Date " + str + " parse error at position " + pp.getErrorIndex());
        }
        return date;
    }

    public boolean equals(Object testtlv) {
        if (!(testtlv instanceof PrimitiveTLV)) {
            return false;
        }
        return Arrays.equals(this.value, ((PrimitiveTLV)testtlv).value);
    }

    @Override
    public String dump(int indent) {
        StringBuffer buffer = new StringBuffer(80);
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        if (this.name != null) {
            buffer.append(this.name);
            buffer.append(' ');
        }
        buffer.append(this.tag.toString());
        buffer.append(" SIZE( " + this.value.length + " )");
        buffer.append('\n');
        buffer.append(HexString.dump(this.value, 0, this.value.length, 16, indent + 2));
        return buffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(80);
        if (this.name != null) {
            buffer.append(this.name);
            buffer.append(' ');
        }
        buffer.append(this.tag.toString());
        if (this.tag.getClazz() == 0) {
            try {
                switch (this.tag.getNumber()) {
                    case 12: {
                        buffer.append(" \"");
                        buffer.append(new String(this.value, "UTF-8"));
                        buffer.append('\"');
                        break;
                    }
                    case 18: 
                    case 19: 
                    case 20: 
                    case 23: 
                    case 24: 
                    case 27: 
                    case 28: 
                    case 30: {
                        buffer.append(" \"");
                        buffer.append(new String(this.value, "8859_1"));
                        buffer.append('\"');
                        break;
                    }
                    case 2: {
                        BigInteger bi = new BigInteger(this.value);
                        buffer.append(' ');
                        buffer.append(bi);
                        buffer.append(" ('");
                        buffer.append(HexString.hexifyByteArray(this.value));
                        buffer.append("')");
                        break;
                    }
                    default: {
                        buffer.append(' ');
                        buffer.append(HexString.hexifyByteArray(this.value));
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                buffer.append(' ');
                buffer.append(HexString.hexifyByteArray(this.value));
            }
        } else {
            buffer.append(' ');
            buffer.append(HexString.hexifyByteArray(this.value));
        }
        return buffer.toString();
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public TreeNode getChildAt(int index) {
        return null;
    }

    @Override
    public int getIndex(TreeNode child) {
        return -1;
    }
}

