/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKeySpec;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.Tag;

public class SmartCardHSMRSAPrivateKeySpec
extends SmartCardHSMPrivateKeySpec {
    public static final byte[] TA_RSA_V15_SHA_256 = new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 2};
    private int exponent;
    private int modulusSize;

    public SmartCardHSMRSAPrivateKeySpec(String car, String chr, int exponent, int size) {
        super(car, chr);
        this.algorithm = TA_RSA_V15_SHA_256;
        this.exponent = exponent;
        this.modulusSize = size;
    }

    public SmartCardHSMRSAPrivateKeySpec(int size) {
        this("UT-00000", "UT-00000", 65537, size);
    }

    @Override
    protected ConstructedTLV encodeKeyParams() {
        ConstructedTLV puk = new ConstructedTLV(new Tag(73, 64, true));
        puk.add(new ObjectIdentifier(this.getAlgorithm()));
        IntegerTLV exp = new IntegerTLV(this.exponent);
        exp.setTag(new Tag(2, -128, false));
        puk.add(exp);
        puk.add(new IntegerTLV(this.modulusSize));
        return puk;
    }

    public int getModulusSize() {
        return this.modulusSize;
    }

    public void setExponent(int exponent) {
        this.exponent = exponent;
    }
}

