/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm;

import de.dfncert.soap.DFNCERTTypesRequestInfo;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static boolean isRootCertificate(X509Certificate certificate) {
        return certificate.getIssuerX500Principal().equals(certificate.getSubjectX500Principal());
    }

    public static byte[] getSubjectKeyId(X509Certificate certificate) {
        byte[] ext = certificate.getExtensionValue("2.5.29.14");
        if (ext == null) {
            return null;
        }
        byte[] octets = DEROctetString.getInstance((Object)ext).getOctets();
        SubjectKeyIdentifier skis = SubjectKeyIdentifier.getInstance((Object)octets);
        byte[] skid = skis.getKeyIdentifier();
        return skid;
    }

    public static byte[] getAuthorityKeyIdentifier(X509Certificate certificate) {
        byte[] ext = certificate.getExtensionValue("2.5.29.35");
        if (ext == null) {
            return null;
        }
        byte[] octets = DEROctetString.getInstance((Object)ext).getOctets();
        AuthorityKeyIdentifier akis = AuthorityKeyIdentifier.getInstance((Object)octets);
        byte[] akid = akis.getKeyIdentifier();
        return akid;
    }

    public static CertificateDTO toCertificateDTO(X509Certificate cert, byte[] skid, long holderId, long srId) throws CertificateEncodingException {
        CertificateDTO certDTO = new CertificateDTO();
        certDTO.setBytes(cert.getEncoded());
        certDTO.setKeyId(skid);
        certDTO.setHolderId(Long.valueOf(holderId));
        certDTO.setExpiry(Long.valueOf(cert.getNotAfter().getTime()));
        if (Utils.isRootCertificate(cert)) {
            certDTO.setLinkDir(1);
        } else {
            certDTO.setLinkDir(0);
        }
        certDTO.setSerial(cert.getSerialNumber().toString());
        certDTO.setServiceRequestId(Long.valueOf(srId));
        return certDTO;
    }

    public static X509Certificate toX509Certificate(String pem) throws CertificateException, IOException {
        PEMParser p = new PEMParser((Reader)new StringReader(pem));
        JcaX509CertificateConverter x509Converter = new JcaX509CertificateConverter();
        X509Certificate certificate = x509Converter.getCertificate((X509CertificateHolder)p.readObject());
        return certificate;
    }

    public static CertificateDTO importCertificate(X509Certificate cert, Long subjectId, boolean updateCurrentCertificate, long srId) throws CertificateException {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            byte[] akid = Utils.getAuthorityKeyIdentifier(cert);
            byte[] skid = Utils.getSubjectKeyId(cert);
            List certs = certDAO.getCertificateByKeyId(skid);
            Long holderId = null;
            if (certs.isEmpty()) {
                HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
                String subjectDN = cert.getSubjectX500Principal().getName();
                if (subjectDN.length() > 100) {
                    subjectDN = subjectDN.substring(0, 100);
                }
                if (Utils.isRootCertificate(cert)) {
                    holderId = holderDAO.getRootHolderId(2, subjectDN);
                    if (holderId == null) {
                        HolderDTO holder = new HolderDTO();
                        holder.setName(subjectDN);
                        holder.setCertificateType(2);
                        if (subjectId != null) {
                            holder.setSubjectId(subjectId);
                        }
                        holderId = holderDAO.insert(holder);
                    }
                } else {
                    List issuerCerts = certDAO.getCertificateByKeyId(akid);
                    if (issuerCerts.isEmpty()) {
                        throw new CertificateException("Invalid certificate path for " + String.valueOf(cert));
                    }
                    long parentId = ((CertificateDTO)issuerCerts.get(0)).getHolderId();
                    if (subjectId != null) {
                        try {
                            holderId = holderDAO.getHolderId(2, Long.valueOf(parentId), subjectId);
                        }
                        catch (Exception e) {
                            new CertificateException(e);
                        }
                    } else {
                        holderId = holderDAO.getHolderId(2, Long.valueOf(parentId), subjectDN);
                    }
                    if (holderId == null) {
                        HolderDTO holder = new HolderDTO();
                        holder.setName(subjectDN);
                        holder.setCertificateType(2);
                        holder.setParentId(Long.valueOf(parentId));
                        if (subjectId != null) {
                            holder.setSubjectId(subjectId);
                        }
                        holderId = holderDAO.insert(holder);
                    }
                }
            } else {
                holderId = ((CertificateDTO)certs.get(0)).getHolderId();
            }
            CertificateDTO certDTO = Utils.toCertificateDTO(cert, skid, holderId, srId);
            boolean isRenewed = false;
            for (CertificateDTO c : certs) {
                if (certDTO.getExpiry() <= c.getExpiry()) continue;
                isRenewed = true;
                break;
            }
            if (isRenewed || certs.isEmpty()) {
                logger.info("Import certificate " + String.valueOf(certDTO));
                certDAO.create(certDTO);
                if (updateCurrentCertificate) {
                    HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
                    holderDAO.updateCurrentCertificate(certDTO.getId(), holderId);
                }
            }
            CertificateDTO certificateDTO = certDTO;
            return certificateDTO;
        }
    }

    public static void setCertificateRevocationStatus(long srId, int status) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            List certs = certDAO.getCertificateByServiceRequestId(Long.valueOf(srId));
            if (certs.size() != 1) {
                throw new RuntimeException("Too many certificates found for service request id " + srId);
            }
            certDAO.updateStatus(status, ((CertificateDTO)certs.get(0)).getId());
        }
    }

    public static boolean isApproved(DFNCERTTypesRequestInfo info) throws Exception {
        boolean isApproved = false;
        String status = info.getStatus();
        logger.debug("Status of the certificate request " + info.getStatus());
        switch (status) {
            case "APPROVED": 
            case "ARCHIVED": {
                isApproved = true;
            }
        }
        return isApproved;
    }
}

